/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

public final class SourceSection {
    static volatile AbstractPolyglotImpl.AbstractSourceSectionDispatch DISPATCH;
    final Source source;
    final Object receiver;

    SourceSection(Source source, Object receiver) {
        this.source = source;
        this.receiver = receiver;
    }

    public boolean isAvailable() {
        return DISPATCH.isAvailable(this.receiver);
    }

    public boolean hasLines() {
        return DISPATCH.hasLines(this.receiver);
    }

    public boolean hasColumns() {
        return DISPATCH.hasColumns(this.receiver);
    }

    public boolean hasCharIndex() {
        return DISPATCH.hasCharIndex(this.receiver);
    }

    public Source getSource() {
        return this.source;
    }

    public int getStartLine() {
        return DISPATCH.getStartLine(this.receiver);
    }

    public int getStartColumn() {
        return DISPATCH.getStartColumn(this.receiver);
    }

    public int getEndLine() {
        return DISPATCH.getEndLine(this.receiver);
    }

    public int getEndColumn() {
        return DISPATCH.getEndColumn(this.receiver);
    }

    public int getCharIndex() {
        return DISPATCH.getCharIndex(this.receiver);
    }

    public int getCharLength() {
        return DISPATCH.getCharLength(this.receiver);
    }

    public int getCharEndIndex() {
        return DISPATCH.getCharEndIndex(this.receiver);
    }

    @Deprecated
    public CharSequence getCode() {
        return DISPATCH.getCode(this.receiver);
    }

    public CharSequence getCharacters() {
        return DISPATCH.getCode(this.receiver);
    }

    public String toString() {
        return DISPATCH.toString(this.receiver);
    }

    public int hashCode() {
        return DISPATCH.hashCode(this.receiver);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object otherImpl = obj;
        if (otherImpl instanceof SourceSection) {
            otherImpl = ((SourceSection)obj).receiver;
        }
        return DISPATCH.equals(this.receiver, otherImpl);
    }
}

