/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Booleans;
import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.RawString;
import io.quarkus.qute.Results;
import io.quarkus.qute.ValueResolver;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class ValueResolvers {
    static final String THIS = "this";

    public static ValueResolver rawResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && (context.getName().equals("raw") || context.getName().equals("safe"));
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return CompletedStage.of(new RawString(context.getBase().toString()));
            }
        };
    }

    public static ValueResolver listResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, List.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.listResolveAsync(context);
            }
        };
    }

    public static ValueResolver collectionResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Collection.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.collectionResolveAsync(context);
            }
        };
    }

    public static ValueResolver thisResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && ValueResolvers.THIS.equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return CompletedStage.of(context.getBase());
            }
        };
    }

    public static ValueResolver orResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                if (context.getParams().size() != 1) {
                    return false;
                }
                String name = context.getName();
                return name.equals("?:") || name.equals("or") || name.equals(":");
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                Object base = context.getBase();
                if (base == null || Results.isNotFound(base) || base instanceof Optional && ((Optional)base).isEmpty()) {
                    return context.evaluate(context.getParams().get(0));
                }
                return CompletedStage.of(base);
            }
        };
    }

    public static ValueResolver orEmpty() {
        final CompletedStage empty = CompletedStage.of(Collections.emptyList());
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getParams().isEmpty() && context.getName().equals("orEmpty");
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                if (context.getBase() == null || Results.isNotFound(context.getBase())) {
                    return empty;
                }
                return CompletedStage.of(context.getBase());
            }
        };
    }

    public static ValueResolver trueResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                if (context.getParams().size() != 1) {
                    return false;
                }
                String name = context.getName();
                return name.equals("?") || name.equals("ifTruthy");
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                if (Booleans.isFalsy(context.getBase())) {
                    return Results.notFound(context);
                }
                return context.evaluate(context.getParams().get(0));
            }
        };
    }

    public static ValueResolver mapEntryResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Map.Entry.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                Map.Entry entry = (Map.Entry)context.getBase();
                return CompletedStage.of(ValueResolvers.entryResolve(entry, context.getName()));
            }
        };
    }

    public static ValueResolver mapResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Map.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.mapResolveAsync(context);
            }
        };
    }

    public static ValueResolver mapperResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                if (context.getBase() instanceof Mapper && context.getParams().isEmpty()) {
                    return ((Mapper)context.getBase()).appliesTo(context.getName());
                }
                return false;
            }

            @Override
            public int getPriority() {
                return 5;
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                Mapper mapper = (Mapper)context.getBase();
                return mapper.getAsync(context.getName());
            }
        };
    }

    public static ValueResolver logicalAndResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && context.getParams().size() == 1 && "&&".equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                boolean baseIsFalsy = Booleans.isFalsy(context.getBase());
                return baseIsFalsy ? CompletedStage.of(false) : context.evaluate(context.getParams().get(0)).thenApply(new Function<Object, Object>(){

                    @Override
                    public Object apply(Object booleanParam) {
                        return !Booleans.isFalsy(booleanParam);
                    }
                });
            }
        };
    }

    public static ValueResolver logicalOrResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && context.getParams().size() == 1 && "||".equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                boolean baseIsFalsy = Booleans.isFalsy(context.getBase());
                return !baseIsFalsy ? CompletedStage.of(true) : context.evaluate(context.getParams().get(0)).thenApply(new Function<Object, Object>(){

                    @Override
                    public Object apply(Object booleanParam) {
                        return !Booleans.isFalsy(booleanParam);
                    }
                });
            }
        };
    }

    public static ValueResolver arrayResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && context.getBase().getClass().isArray();
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                int index;
                String name = context.getName();
                if (name.equals("length") || name.equals("size")) {
                    return CompletedStage.of(Array.getLength(context.getBase()));
                }
                if (name.equals("take")) {
                    if (context.getParams().isEmpty()) {
                        throw new IllegalArgumentException("n-th parameter is missing");
                    }
                    Expression indexExpr = context.getParams().get(0);
                    if (indexExpr.isLiteral()) {
                        Object literalValue = indexExpr.getLiteral();
                        if (literalValue instanceof Integer) {
                            return CompletedStage.of(ValueResolvers.takeArray((Integer)literalValue, context.getBase()));
                        }
                        return Results.notFound(context);
                    }
                    return context.evaluate(indexExpr).thenCompose(n -> {
                        if (n instanceof Integer) {
                            return CompletedStage.of(ValueResolvers.takeArray((Integer)n, context.getBase()));
                        }
                        return Results.notFound(context);
                    });
                }
                if (name.equals("takeLast")) {
                    if (context.getParams().isEmpty()) {
                        throw new IllegalArgumentException("n-th parameter is missing");
                    }
                    Expression indexExpr = context.getParams().get(0);
                    if (indexExpr.isLiteral()) {
                        Object literalValue = indexExpr.getLiteral();
                        if (literalValue instanceof Integer) {
                            return CompletedStage.of(ValueResolvers.takeLastArray((Integer)literalValue, context.getBase()));
                        }
                        return Results.notFound(context);
                    }
                    return context.evaluate(indexExpr).thenCompose(n -> {
                        if (n instanceof Integer) {
                            return CompletedStage.of(ValueResolvers.takeLastArray((Integer)n, context.getBase()));
                        }
                        return Results.notFound(context);
                    });
                }
                if (name.equals("get")) {
                    if (context.getParams().isEmpty()) {
                        throw new IllegalArgumentException("Index parameter is missing");
                    }
                    Expression indexExpr = context.getParams().get(0);
                    if (indexExpr.isLiteral()) {
                        Object literalValue = indexExpr.getLiteral();
                        if (literalValue instanceof Integer) {
                            return CompletedStage.of(Array.get(context.getBase(), (Integer)literalValue));
                        }
                        return Results.notFound(context);
                    }
                    return context.evaluate(indexExpr).thenCompose(idx -> {
                        if (idx instanceof Integer) {
                            return CompletedStage.of(Array.get(context.getBase(), (Integer)idx));
                        }
                        return Results.notFound(context);
                    });
                }
                try {
                    index = Integer.parseInt(name);
                }
                catch (NumberFormatException e) {
                    return Results.notFound(context);
                }
                return CompletedStage.of(Array.get(context.getBase(), index));
            }
        };
    }

    private static Object takeArray(int n, Object sourceArray) {
        int size = Array.getLength(sourceArray);
        if (n < 1 || n > size) {
            throw new IndexOutOfBoundsException(n);
        }
        Object targetArray = Array.newInstance(sourceArray.getClass().getComponentType(), n);
        System.arraycopy(sourceArray, 0, targetArray, 0, n);
        return targetArray;
    }

    private static Object takeLastArray(int n, Object sourceArray) {
        int size = Array.getLength(sourceArray);
        if (n < 1 || n > size) {
            throw new IndexOutOfBoundsException(n);
        }
        Object targetArray = Array.newInstance(sourceArray.getClass().getComponentType(), n);
        System.arraycopy(sourceArray, size - n, targetArray, 0, n);
        return targetArray;
    }

    private static CompletionStage<Object> collectionResolveAsync(EvalContext context) {
        Collection collection = (Collection)context.getBase();
        switch (context.getName()) {
            case "size": {
                return CompletedStage.of(collection.size());
            }
            case "isEmpty": 
            case "empty": {
                return CompletedStage.of(collection.isEmpty());
            }
            case "contains": {
                if (context.getParams().size() != 1) break;
                return context.evaluate(context.getParams().get(0)).thenCompose(e -> CompletedStage.of(collection.contains(e)));
            }
        }
        return Results.notFound(context);
    }

    private static CompletionStage<Object> listResolveAsync(EvalContext context) {
        List list = (List)context.getBase();
        switch (context.getName()) {
            case "get": {
                if (context.getParams().size() == 1) {
                    return context.evaluate(context.getParams().get(0)).thenApply(r -> {
                        try {
                            int idx = r instanceof Integer ? (Integer)r : Integer.valueOf(r.toString());
                            if (idx >= list.size()) {
                                return Results.NotFound.from(context);
                            }
                            return list.get(idx);
                        }
                        catch (NumberFormatException e) {
                            return Results.NotFound.from(context);
                        }
                    });
                }
            }
            case "take": {
                if (context.getParams().size() == 1) {
                    return context.evaluate(context.getParams().get(0)).thenApply(r -> {
                        try {
                            int n = r instanceof Integer ? (Integer)r : Integer.valueOf(r.toString());
                            if (n < 1 || n > list.size()) {
                                throw new IndexOutOfBoundsException(n);
                            }
                            return list.subList(0, n);
                        }
                        catch (NumberFormatException e) {
                            return Results.NotFound.from(context);
                        }
                    });
                }
            }
            case "takeLast": {
                if (context.getParams().size() != 1) break;
                return context.evaluate(context.getParams().get(0)).thenApply(r -> {
                    try {
                        int n = r instanceof Integer ? (Integer)r : Integer.valueOf(r.toString());
                        if (n < 1 || n > list.size()) {
                            throw new IndexOutOfBoundsException(n);
                        }
                        return list.subList(list.size() - n, list.size());
                    }
                    catch (NumberFormatException e) {
                        return Results.NotFound.from(context);
                    }
                });
            }
        }
        return Results.notFound(context);
    }

    private static Object entryResolve(Map.Entry<?, ?> entry, String name) {
        switch (name) {
            case "key": 
            case "getKey": {
                return entry.getKey();
            }
            case "value": 
            case "getValue": {
                return entry.getValue();
            }
        }
        return Results.NotFound.from(name);
    }

    private static CompletionStage<Object> mapResolveAsync(EvalContext context) {
        String name;
        Map map = (Map)context.getBase();
        switch (name = context.getName()) {
            case "keys": 
            case "keySet": {
                return CompletedStage.of(map.keySet());
            }
            case "values": {
                return CompletedStage.of(map.values());
            }
            case "entrySet": {
                return CompletedStage.of(map.entrySet());
            }
            case "size": {
                return CompletedStage.of(map.size());
            }
            case "empty": 
            case "isEmpty": {
                return map.isEmpty() ? Results.TRUE : Results.FALSE;
            }
            case "get": {
                if (context.getParams().size() == 1) {
                    return context.evaluate(context.getParams().get(0)).thenCompose(k -> CompletedStage.of(map.get(k)));
                }
            }
            case "containsKey": {
                if (context.getParams().size() != 1) break;
                return context.evaluate(context.getParams().get(0)).thenCompose(k -> CompletedStage.of(map.containsKey(k)));
            }
        }
        Object val = map.get(name);
        if (val == null) {
            return map.containsKey(name) ? Results.NULL : Results.notFound(context);
        }
        return CompletedStage.of(val);
    }
}

