/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.dev.ErrorPageGenerators;
import io.quarkus.dev.config.ConfigurationProblem;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.runtime.util.ExceptionUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.eclipse.microprofile.config.ConfigProvider;

public class ReplacementDebugPage {
    public static String generateHtml(Throwable exception, String currentUri) {
        Function<Throwable, String> generator;
        Throwable rootCause = ExceptionUtil.getRootCause(exception);
        if (rootCause == null) {
            rootCause = exception;
        }
        if ((generator = ErrorPageGenerators.get(rootCause.getClass().getName())) != null) {
            return generator.apply(rootCause);
        }
        HashSet<String> configErrors = new HashSet<String>();
        HashSet<Throwable> seen = new HashSet<Throwable>();
        ArrayDeque<Throwable> toProcess = new ArrayDeque<Throwable>();
        toProcess.add(exception);
        while (!toProcess.isEmpty()) {
            Throwable ex = (Throwable)toProcess.poll();
            if (seen.contains(ex)) continue;
            if (ex instanceof ConfigurationProblem) {
                configErrors.addAll(((ConfigurationProblem)((Object)ex)).getConfigKeys());
            }
            seen.add(ex);
            if (ex.getCause() != null) {
                toProcess.add(ex.getCause());
            }
            toProcess.addAll(Arrays.asList(ex.getSuppressed()));
        }
        ArrayList<CurrentConfig> toEdit = new ArrayList<CurrentConfig>();
        List<CurrentConfig> keys = CurrentConfig.CURRENT;
        for (CurrentConfig currentConfig : keys) {
            if (!configErrors.contains(currentConfig.getPropertyName())) continue;
            toEdit.add(currentConfig);
            configErrors.remove(currentConfig.getPropertyName());
        }
        for (String string : configErrors) {
            toEdit.add(new CurrentConfig(string, "", "", ConfigProvider.getConfig().getOptionalValue(string, String.class).orElse(null), null));
        }
        TemplateHtmlBuilder builder = new TemplateHtmlBuilder("Error restarting Quarkus", exception.getClass().getName(), ReplacementDebugPage.generateHeaderMessage(exception), currentUri, toEdit);
        builder.stack(exception);
        return builder.toString();
    }

    private static String generateHeaderMessage(Throwable exception) {
        return String.format("%s: %s", exception.getClass().getName(), ReplacementDebugPage.extractFirstLine(exception.getMessage()));
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }
}

