/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.EventImpl;
import io.quarkus.arc.impl.LazyValue;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import org.jboss.logging.Logger;

class RequestContext
implements ManagedContext {
    private static final Logger LOGGER = Logger.getLogger(RequestContext.class.getPackage().getName());
    private final ThreadLocal<ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>>> currentContext = new ThreadLocal();
    private final LazyValue<EventImpl.Notifier<Object>> initializedNotifier = new LazyValue<EventImpl.Notifier>(RequestContext::createInitializedNotifier);
    private final LazyValue<EventImpl.Notifier<Object>> beforeDestroyedNotifier = new LazyValue<EventImpl.Notifier>(RequestContext::createBeforeDestroyedNotifier);
    private final LazyValue<EventImpl.Notifier<Object>> destroyedNotifier = new LazyValue<EventImpl.Notifier>(RequestContext::createDestroyedNotifier);

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    public <T> T getIfActive(Contextual<T> contextual, Function<Contextual<T>, CreationalContext<T>> creationalContextFun) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        Objects.requireNonNull(creationalContextFun, "CreationalContext supplier must not be null");
        Map ctx = this.currentContext.get();
        if (ctx == null) {
            return null;
        }
        ContextInstanceHandleImpl<T> instance = (ContextInstanceHandleImpl<T>)ctx.get(contextual);
        if (instance == null) {
            CreationalContext<T> creationalContext = creationalContextFun.apply(contextual);
            instance = new ContextInstanceHandleImpl<T>((InjectableBean)contextual, contextual.create(creationalContext), creationalContext);
            ctx.put(contextual, instance);
        }
        return instance.get();
    }

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T result = this.getIfActive(contextual, CreationalContextImpl.unwrap(Objects.requireNonNull(creationalContext, "CreationalContext must not be null")));
        if (result == null) {
            throw new ContextNotActiveException();
        }
        return result;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        Map ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        ContextInstanceHandle instance = (ContextInstanceHandle)ctx.get(contextual);
        return instance == null ? null : (T)instance.get();
    }

    @Override
    public boolean isActive() {
        return this.currentContext.get() != null;
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        Map ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        ContextInstanceHandle instance = (ContextInstanceHandle)ctx.remove(contextual);
        if (instance != null) {
            instance.destroy();
        }
    }

    @Override
    public void activate(InjectableContext.ContextState initialState) {
        if (initialState == null) {
            this.currentContext.set(new ConcurrentHashMap());
            this.fireIfNotEmpty(this.initializedNotifier);
        } else if (initialState instanceof RequestContextState) {
            this.currentContext.set(((RequestContextState)initialState).value);
        } else {
            throw new IllegalArgumentException("Invalid initial state: " + initialState.getClass().getName());
        }
    }

    @Override
    public InjectableContext.ContextState getState() {
        ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        return new RequestContextState(ctx);
    }

    @Override
    public InjectableContext.ContextState getStateIfActive() {
        ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return null;
        }
        return new RequestContextState(ctx);
    }

    @Override
    public void deactivate() {
        this.currentContext.remove();
    }

    @Override
    public void destroy() {
        this.destroy((Map)this.currentContext.get());
    }

    @Override
    public void destroy(InjectableContext.ContextState state) {
        if (!(state instanceof RequestContextState)) {
            throw new IllegalArgumentException("Invalid state: " + state.getClass().getName());
        }
        this.destroy(((RequestContextState)state).value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(Map<Contextual<?>, ContextInstanceHandle<?>> currentContext) {
        if (currentContext != null) {
            Map<Contextual<?>, ContextInstanceHandle<?>> map = currentContext;
            synchronized (map) {
                try {
                    this.fireIfNotEmpty(this.beforeDestroyedNotifier);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"An error occurred during delivery of the @BeforeDestroyed(RequestScoped.class) event", e);
                }
                currentContext.forEach(this::destroyContextElement);
                try {
                    this.fireIfNotEmpty(this.destroyedNotifier);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"An error occurred during delivery of the @Destroyed(RequestScoped.class) event", e);
                }
                currentContext.clear();
            }
        }
    }

    private void destroyContextElement(Contextual<?> contextual, ContextInstanceHandle<?> contextInstanceHandle) {
        try {
            contextInstanceHandle.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to destroy instance" + contextInstanceHandle.get(), e);
        }
    }

    private void fireIfNotEmpty(LazyValue<EventImpl.Notifier<Object>> value) {
        EventImpl.Notifier<Object> notifier = value.get();
        if (!notifier.isEmpty()) {
            notifier.notify(this.toString());
        }
    }

    private static EventImpl.Notifier<Object> createInitializedNotifier() {
        return EventImpl.createNotifier(Object.class, Object.class, new HashSet<Annotation>(Arrays.asList(Initialized.Literal.REQUEST, Any.Literal.INSTANCE)), ArcContainerImpl.instance(), false);
    }

    private static EventImpl.Notifier<Object> createBeforeDestroyedNotifier() {
        return EventImpl.createNotifier(Object.class, Object.class, new HashSet<Annotation>(Arrays.asList(BeforeDestroyed.Literal.REQUEST, Any.Literal.INSTANCE)), ArcContainerImpl.instance(), false);
    }

    private static EventImpl.Notifier<Object> createDestroyedNotifier() {
        return EventImpl.createNotifier(Object.class, Object.class, new HashSet<Annotation>(Arrays.asList(Destroyed.Literal.REQUEST, Any.Literal.INSTANCE)), ArcContainerImpl.instance(), false);
    }

    static class RequestContextState
    implements InjectableContext.ContextState {
        private final ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>> value;

        RequestContextState(ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>> value) {
            this.value = value;
        }

        @Override
        public Map<InjectableBean<?>, Object> getContextualInstances() {
            return this.value.values().stream().collect(Collectors.toUnmodifiableMap(InstanceHandle::getBean, InstanceHandle::get));
        }
    }
}

