/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.OidcSession;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.time.Instant;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class OidcSessionImpl
implements OidcSession {
    @Inject
    RoutingContext routingContext;
    @Inject
    DefaultTenantConfigResolver resolver;
    @Inject
    @IdToken
    JsonWebToken idToken;

    @Override
    public String getTenantId() {
        return (String)this.routingContext.get("tenant-id");
    }

    @Override
    public Uni<Void> logout() {
        final String sessionCookieName = (String)this.routingContext.get("q_session");
        if (sessionCookieName != null) {
            Uni<OidcTenantConfig> oidcConfigUni = this.resolver.resolveConfig(this.routingContext);
            return oidcConfigUni.onItem().transformToUni(new Function<OidcTenantConfig, Uni<? extends Void>>(){

                @Override
                public Uni<Void> apply(OidcTenantConfig oidcConfig) {
                    return OidcUtils.removeSessionCookie(OidcSessionImpl.this.routingContext, oidcConfig, sessionCookieName, OidcSessionImpl.this.resolver.getTokenStateManager());
                }
            });
        }
        return Uni.createFrom().voidItem();
    }

    @Override
    public Instant expiresIn() {
        long nowSecs = System.currentTimeMillis() / 1000L;
        return Instant.ofEpochSecond(this.idToken.getExpirationTime() - nowSecs);
    }

    @Override
    public JsonWebToken getIdToken() {
        return this.idToken;
    }
}

