/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigValue;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class ConfigValueMapStringView
extends AbstractMap<String, ConfigValue> {
    private final Map<String, String> delegate;
    private final String configSourceName;
    private final int configSourceOrdinal;
    private Set<Map.Entry<String, ConfigValue>> entrySet;
    private Collection<ConfigValue> values;

    public ConfigValueMapStringView(Map<String, String> delegate, String configSourceName, int configSourceOrdinal) {
        this.delegate = Collections.unmodifiableMap(delegate);
        this.configSourceName = configSourceName;
        this.configSourceOrdinal = configSourceOrdinal;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ConfigValue configValue = (ConfigValue)value;
        if (configValue == null || configValue.getValue() == null) {
            return this.delegate.containsValue(null);
        }
        return this.delegate.containsValue(configValue.getValue());
    }

    @Override
    public ConfigValue get(Object key) {
        String value = this.delegate.get(key);
        if (value == null) {
            return null;
        }
        return this.toConfigValue((String)key, value);
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<String, ConfigValue>>(){

                @Override
                public Iterator<Map.Entry<String, ConfigValue>> iterator() {
                    return new Iterator<Map.Entry<String, ConfigValue>>(){
                        final Iterator<Map.Entry<String, String>> delegate;
                        {
                            this.delegate = ConfigValueMapStringView.this.delegate.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.delegate.hasNext();
                        }

                        @Override
                        public Map.Entry<String, ConfigValue> next() {
                            Map.Entry<String, String> next = this.delegate.next();
                            String value = next.getValue();
                            return value != null ? new AbstractMap.SimpleImmutableEntry<String, ConfigValue>(next.getKey(), ConfigValueMapStringView.this.toConfigValue(next.getKey(), value)) : new AbstractMap.SimpleImmutableEntry<String, Object>(next.getKey(), null);
                        }
                    };
                }

                @Override
                public int size() {
                    return ConfigValueMapStringView.this.delegate.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public Collection<ConfigValue> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<ConfigValue>(){

                @Override
                public Iterator<ConfigValue> iterator() {
                    final Iterator<Map.Entry<String, ConfigValue>> delegate = ConfigValueMapStringView.this.entrySet().iterator();
                    return new Iterator<ConfigValue>(){

                        @Override
                        public boolean hasNext() {
                            return delegate.hasNext();
                        }

                        @Override
                        public ConfigValue next() {
                            Map.Entry next = (Map.Entry)delegate.next();
                            return next != null ? (ConfigValue)next.getValue() : null;
                        }
                    };
                }

                @Override
                public int size() {
                    return ConfigValueMapStringView.this.delegate.size();
                }
            };
        }
        return this.values;
    }

    private ConfigValue toConfigValue(String name, String value) {
        return ConfigValue.builder().withName(name).withValue(value).withRawValue(value).withConfigSourceName(this.configSourceName).withConfigSourceOrdinal(this.configSourceOrdinal).build();
    }
}

