/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;

@VertxGen
public interface SockJSSocket
extends ReadStream<Buffer>,
WriteStream<Buffer> {
    @Override
    public SockJSSocket exceptionHandler(Handler<Throwable> var1);

    public SockJSSocket handler(Handler<Buffer> var1);

    public SockJSSocket pause();

    public SockJSSocket resume();

    public SockJSSocket fetch(long var1);

    public SockJSSocket endHandler(Handler<Void> var1);

    public SockJSSocket closeHandler(Handler<Void> var1);

    @Override
    default public Future<Void> write(Buffer data) {
        Promise<Void> promise = Promise.promise();
        this.write(data, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    default public Future<Void> write(String data) {
        Promise<Void> promise = Promise.promise();
        this.write(data, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    default public void write(String data, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(data), handler);
    }

    @Override
    public void write(Buffer var1, Handler<AsyncResult<Void>> var2);

    public SockJSSocket setWriteQueueMaxSize(int var1);

    public SockJSSocket drainHandler(Handler<Void> var1);

    public String writeHandlerID();

    @Override
    public Future<Void> end();

    public void close();

    default public void close(int statusCode, String reason) {
        this.close();
    }

    public SocketAddress remoteAddress();

    public SocketAddress localAddress();

    public MultiMap headers();

    public String uri();

    public RoutingContext routingContext();

    public @Nullable Session webSession();

    public @Nullable User webUser();
}

