/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.JsonUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.json.JsonValue;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public abstract class JWTCallerPrincipal
implements JsonWebToken {
    private final String rawToken;
    private final String tokenType;

    public JWTCallerPrincipal(String rawToken, String tokenType) {
        this.rawToken = rawToken;
        this.tokenType = tokenType;
    }

    @Override
    public String getName() {
        String principalName = (String)this.getClaim(Claims.upn.name());
        if (principalName == null && (principalName = (String)this.getClaim(Claims.preferred_username.name())) == null) {
            principalName = (String)this.getClaim(Claims.sub.name());
        }
        return principalName;
    }

    @Override
    public Set<String> getClaimNames() {
        HashSet<String> names = new HashSet<String>(this.doGetClaimNames());
        names.add(Claims.raw_token.name());
        return names;
    }

    protected abstract Collection<String> doGetClaimNames();

    @Override
    public <T> T getClaim(String claimName) {
        Object claimValue = Claims.raw_token.name().equals(claimName) ? this.rawToken : this.getClaimValue(claimName);
        return (T)claimValue;
    }

    protected abstract Object getClaimValue(String var1);

    @Override
    public boolean implies(Subject subject) {
        return false;
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean showAll) {
        String toString = "DefaultJWTCallerPrincipal{id='" + this.getTokenID() + '\'' + ", name='" + this.getName() + '\'' + ", expiration=" + this.getExpirationTime() + ", notBefore=" + this.getClaim(Claims.nbf.name()) + ", issuedAt=" + this.getIssuedAtTime() + ", issuer='" + this.getIssuer() + '\'' + ", audience=" + this.getAudience() + ", subject='" + this.getSubject() + '\'' + ", type='" + this.tokenType + '\'' + ", issuedFor='" + this.getClaim("azp") + '\'' + ", authTime=" + this.getClaim("auth_time") + ", givenName='" + this.getClaim("given_name") + '\'' + ", familyName='" + this.getClaim("family_name") + '\'' + ", middleName='" + this.getClaim("middle_name") + '\'' + ", nickName='" + this.getClaim("nickname") + '\'' + ", preferredUsername='" + this.getClaim("preferred_username") + '\'' + ", email='" + this.getClaim("email") + '\'' + ", emailVerified=" + this.getClaim(Claims.email_verified.name()) + ", allowedOrigins=" + this.getClaim("allowedOrigins") + ", updatedAt=" + this.getClaim("updated_at") + ", acr='" + this.getClaim("acr") + '\'';
        StringBuilder tmp = new StringBuilder(toString);
        tmp.append(", groups=[");
        for (String group : this.getGroups()) {
            tmp.append(group);
            tmp.append(',');
        }
        tmp.setLength(tmp.length() - 1);
        tmp.append("]}");
        return tmp.toString();
    }

    protected JsonValue wrapClaimValue(Object value) {
        return JsonUtils.wrapValue(value);
    }

    protected Claims getClaimType(String claimName) {
        Claims claimType;
        try {
            claimType = Claims.valueOf(claimName);
        }
        catch (IllegalArgumentException e) {
            claimType = Claims.UNKNOWN;
        }
        return claimType;
    }
}

