/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiSwitchOnEmpty;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class MultiIfEmpty<T> {
    private final Multi<T> upstream;

    MultiIfEmpty(Multi<T> upstream) {
        this.upstream = upstream;
    }

    @CheckReturnValue
    public Multi<T> failWith(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        return this.failWith(() -> failure);
    }

    @CheckReturnValue
    public Multi<T> failWith(Supplier<? extends Throwable> supplier) {
        Supplier<? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.switchToEmitter(MultiIfEmpty.createMultiFromFailureSupplier(actual));
    }

    static <T> Consumer<MultiEmitter<? super T>> createMultiFromFailureSupplier(Supplier<? extends Throwable> supplier) {
        return emitter -> {
            Throwable throwable;
            try {
                throwable = (Throwable)supplier.get();
            }
            catch (Throwable e) {
                emitter.fail(e);
                return;
            }
            if (throwable == null) {
                emitter.fail(new NullPointerException("The supplier returned `null`"));
            } else {
                emitter.fail(throwable);
            }
        };
    }

    @CheckReturnValue
    public Multi<T> fail() {
        return this.failWith(NoSuchElementException::new);
    }

    @CheckReturnValue
    public Multi<T> switchToEmitter(Consumer<MultiEmitter<? super T>> consumer) {
        Consumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return this.switchTo(() -> Multi.createFrom().emitter(actual));
    }

    @CheckReturnValue
    public Multi<T> switchTo(Publisher<? extends T> other) {
        return this.switchTo(() -> other);
    }

    @CheckReturnValue
    public Multi<T> switchTo(Supplier<Publisher<? extends T>> supplier) {
        Supplier<Publisher<? extends T>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onMultiCreation(new MultiSwitchOnEmpty<T>(this.upstream, actual));
    }

    @SafeVarargs
    @CheckReturnValue
    public final Multi<T> continueWith(T ... items) {
        ParameterValidation.nonNull(items, "items");
        ParameterValidation.doesNotContainNull(items, "items");
        return this.continueWith(() -> Arrays.asList(items));
    }

    @CheckReturnValue
    public Multi<T> continueWith(Iterable<T> items) {
        ParameterValidation.nonNull(items, "items");
        ParameterValidation.doesNotContainNull(items, "items");
        return this.continueWith(() -> items);
    }

    @CheckReturnValue
    public Multi<T> continueWith(Supplier<? extends Iterable<? extends T>> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.switchTo(() -> MultiIfEmpty.createMultiFromIterableSupplier(actual));
    }

    static <T> Publisher<? extends T> createMultiFromIterableSupplier(Supplier<? extends Iterable<? extends T>> supplier) {
        Iterable<? extends T> iterable;
        try {
            iterable = supplier.get();
        }
        catch (Throwable e) {
            return Multi.createFrom().failure(e);
        }
        if (iterable == null) {
            return Multi.createFrom().failure(new NullPointerException("The supplier returned `null`"));
        }
        return Multi.createFrom().iterable(iterable);
    }
}

