/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Location;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateInstanceBase;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.QuteRecorder;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class TemplateProducer {
    private static final Logger LOGGER = Logger.getLogger(TemplateProducer.class);
    private final Engine engine;
    private final Map<String, TemplateVariants> templateVariants;

    TemplateProducer(Engine engine, QuteRecorder.QuteContext context, ContentTypes contentTypes) {
        this.engine = engine;
        HashMap<String, TemplateVariants> templateVariants = new HashMap<String, TemplateVariants>();
        for (Map.Entry<String, List<String>> entry : context.getVariants().entrySet()) {
            TemplateVariants var = new TemplateVariants(TemplateProducer.initVariants(entry.getKey(), entry.getValue(), contentTypes), entry.getKey());
            templateVariants.put(entry.getKey(), var);
        }
        this.templateVariants = Collections.unmodifiableMap(templateVariants);
        LOGGER.debugf("Initializing Qute variant templates: %s", (Object)templateVariants);
    }

    @Produces
    Template getDefaultTemplate(InjectionPoint injectionPoint) {
        String name = null;
        if (injectionPoint.getMember() instanceof Field) {
            name = injectionPoint.getMember().getName();
        } else {
            AnnotatedParameter parameter = (AnnotatedParameter)injectionPoint.getAnnotated();
            if (parameter.getJavaParameter().isNamePresent()) {
                name = parameter.getJavaParameter().getName();
            } else {
                name = injectionPoint.getMember().getName();
                LOGGER.warnf("Parameter name not present - using the method name as the template name instead %s", (Object)name);
            }
        }
        return new InjectableTemplate(name, this.templateVariants, this.engine);
    }

    @Produces
    @Location(value="ignored")
    Template getTemplate(InjectionPoint injectionPoint) {
        String path = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(Location.class)) continue;
            path = ((Location)qualifier).value();
            break;
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalStateException("No template location specified");
        }
        return new InjectableTemplate(path, this.templateVariants, this.engine);
    }

    public Template getInjectableTemplate(String path) {
        return new InjectableTemplate(path, this.templateVariants, this.engine);
    }

    private static Map<Variant, String> initVariants(String base, List<String> availableVariants, ContentTypes contentTypes) {
        LinkedHashMap<Variant, String> map = new LinkedHashMap<Variant, String>();
        for (String path : availableVariants) {
            if (base.equals(path)) continue;
            map.put(new Variant(null, contentTypes.getContentType(path), null), path);
        }
        return map;
    }

    static class TemplateVariants {
        public final Map<Variant, String> variantToTemplate;
        public final String defaultTemplate;

        public TemplateVariants(Map<Variant, String> variants, String defaultTemplate) {
            this.variantToTemplate = variants;
            this.defaultTemplate = defaultTemplate;
        }

        String getId(String contentType) {
            for (Map.Entry<Variant, String> entry : this.variantToTemplate.entrySet()) {
                if (!entry.getKey().getContentType().equals(contentType)) continue;
                return entry.getValue();
            }
            return null;
        }

        public String toString() {
            return "TemplateVariants [default=" + this.defaultTemplate + ", variants=" + this.variantToTemplate + "]";
        }
    }

    static class InjectableTemplate
    implements Template {
        private final String path;
        private final TemplateVariants variants;
        private final Engine engine;

        public InjectableTemplate(String path, Map<String, TemplateVariants> templateVariants, Engine engine) {
            this.path = path;
            this.variants = templateVariants.get(path);
            this.engine = engine;
        }

        @Override
        public TemplateInstance instance() {
            return new InjectableTemplateInstanceImpl();
        }

        @Override
        public List<Expression> getExpressions() {
            throw new UnsupportedOperationException("Injected templates do not support getExpressions()");
        }

        @Override
        public String getGeneratedId() {
            throw new UnsupportedOperationException("Injected templates do not support getGeneratedId()");
        }

        @Override
        public Optional<Variant> getVariant() {
            throw new UnsupportedOperationException("Injected templates do not support getVariant()");
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException("Injected templates do not support getId()");
        }

        public String toString() {
            return "Injectable template [path=" + this.path + "]";
        }

        class InjectableTemplateInstanceImpl
        extends TemplateInstanceBase {
            InjectableTemplateInstanceImpl() {
                if (InjectableTemplate.this.variants != null) {
                    this.setAttribute("variants", List.copyOf(InjectableTemplate.this.variants.variantToTemplate.keySet()));
                }
            }

            @Override
            public String render() {
                return this.templateInstance().render();
            }

            @Override
            public CompletionStage<String> renderAsync() {
                return this.templateInstance().renderAsync();
            }

            @Override
            public Multi<String> createMulti() {
                return this.templateInstance().createMulti();
            }

            @Override
            public Uni<String> createUni() {
                return this.templateInstance().createUni();
            }

            @Override
            public CompletionStage<Void> consume(Consumer<String> consumer) {
                return this.templateInstance().consume(consumer);
            }

            @Override
            protected Engine engine() {
                return InjectableTemplate.this.engine;
            }

            @Override
            public Template getTemplate() {
                return this.template();
            }

            private TemplateInstance templateInstance() {
                TemplateInstance instance = this.template().instance();
                if (this.dataMap != null) {
                    this.dataMap.forEach(instance::data);
                } else if (this.data != null) {
                    instance.data(this.data);
                }
                if (!this.attributes.isEmpty()) {
                    this.attributes.forEach(instance::setAttribute);
                }
                if (!this.renderedActions.isEmpty()) {
                    this.renderedActions.forEach(instance::onRendered);
                }
                return instance;
            }

            private Template template() {
                String id;
                Variant selected = (Variant)this.getAttribute("selectedVariant");
                if (selected != null) {
                    id = InjectableTemplate.this.variants.getId(selected.getContentType());
                    if (id == null) {
                        id = InjectableTemplate.this.variants.defaultTemplate;
                    }
                } else {
                    id = InjectableTemplate.this.path;
                }
                return InjectableTemplate.this.engine.getTemplate(id);
            }
        }
    }
}

