/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

@Recorder
public class StaticResourcesRecorder {
    public static final String META_INF_RESOURCES = "META-INF/resources";
    private static volatile List<Path> hotDeploymentResourcePaths;
    final RuntimeValue<HttpConfiguration> httpConfiguration;
    final HttpBuildTimeConfig httpBuildTimeConfig;

    public StaticResourcesRecorder(RuntimeValue<HttpConfiguration> httpConfiguration, HttpBuildTimeConfig httpBuildTimeConfig) {
        this.httpConfiguration = httpConfiguration;
        this.httpBuildTimeConfig = httpBuildTimeConfig;
    }

    public static void setHotDeploymentResources(List<Path> resources) {
        hotDeploymentResourcePaths = resources;
    }

    public Consumer<Route> start(final Set<String> knownPaths) {
        final ArrayList<Handler<RoutingContext>> handlers = new ArrayList<Handler<RoutingContext>>();
        if (hotDeploymentResourcePaths != null && !hotDeploymentResourcePaths.isEmpty()) {
            for (Path resourcePath : hotDeploymentResourcePaths) {
                String root = resourcePath.toAbsolutePath().toString();
                final StaticHandler staticHandler = StaticHandler.create();
                staticHandler.setCachingEnabled(false);
                staticHandler.setAllowRootFileSystemAccess(true);
                staticHandler.setWebRoot(root);
                staticHandler.setDefaultContentEncoding("UTF-8");
                handlers.add(new Handler<RoutingContext>(){

                    @Override
                    public void handle(RoutingContext event) {
                        try {
                            staticHandler.handle(event);
                        }
                        catch (Exception e) {
                            event.next();
                        }
                    }
                });
            }
        }
        if (!knownPaths.isEmpty()) {
            final ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            final StaticHandler staticHandler = StaticHandler.create(META_INF_RESOURCES).setDefaultContentEncoding("UTF-8");
            handlers.add(new Handler<RoutingContext>(){

                @Override
                public void handle(RoutingContext ctx) {
                    String rel;
                    String string = ctx.mountPoint() == null ? ctx.normalizedPath() : (rel = ctx.normalizedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length()));
                    if (knownPaths.contains(rel)) {
                        staticHandler.handle(ctx);
                        if (StaticResourcesRecorder.this.httpBuildTimeConfig.enableCompression && StaticResourcesRecorder.this.isCompressed(rel)) {
                            ctx.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
                        }
                    } else {
                        Thread.currentThread().setContextClassLoader(currentCl);
                        ctx.next();
                    }
                }
            });
        }
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                for (Handler i : handlers) {
                    route.handler(i);
                }
            }
        };
    }

    private boolean isCompressed(String path) {
        int lastDot = path.lastIndexOf(46);
        String suffix = lastDot != -1 && lastDot != path.length() - 1 ? path.substring(lastDot + 1) : null;
        String contentType = MimeMapping.getMimeTypeForExtension(suffix);
        return this.httpBuildTimeConfig.compressMediaTypes.orElse(List.of()).contains(contentType);
    }
}

