/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.vertx;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.constraint.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;

public class VertxContext {
    private VertxContext() {
    }

    public static Context getOrCreateDuplicatedContext(Context context) {
        if (VertxContext.isDuplicatedContext(context)) {
            return context;
        }
        return ((ContextInternal)context).duplicate();
    }

    public static Context getOrCreateDuplicatedContext(Vertx vertx) {
        Vertx actual = Assert.checkNotNullParam("vertx", vertx);
        Context context = actual.getOrCreateContext();
        if (VertxContext.isDuplicatedContext(context)) {
            return context;
        }
        return ((ContextInternal)context).duplicate();
    }

    @Nullable
    public static Context getOrCreateDuplicatedContext() {
        Context context = Vertx.currentContext();
        if (context == null) {
            return null;
        }
        return VertxContext.getOrCreateDuplicatedContext(context);
    }

    @Nullable
    public static Context createNewDuplicatedContext() {
        Context context = Vertx.currentContext();
        if (context == null) {
            return null;
        }
        return ((ContextInternal)context).duplicate();
    }

    public static boolean isDuplicatedContext(Context context) {
        Context actual = Assert.checkNotNullParam("context", context);
        return ((ContextInternal)actual).isDuplicate();
    }

    public static boolean isOnDuplicatedContext() {
        Context context = Vertx.currentContext();
        return context != null && VertxContext.isDuplicatedContext(context);
    }

    public static Context getRootContext(Context context) {
        return VertxContext.isDuplicatedContext(context) ? ((ContextInternal)context).unwrap() : context;
    }
}

