/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerImpl;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.arc.runtime.LifecycleEventRunner;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

@Recorder
public class ArcRecorder {
    public static volatile Map<String, Supplier<?>> supplierMap;

    public ArcContainer getContainer(ShutdownContext shutdown) throws Exception {
        ArcContainer container = Arc.initialize();
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                Arc.shutdown();
            }
        });
        return container;
    }

    public void initExecutor(ExecutorService executor) {
        Arc.setExecutor(executor);
    }

    public void initStaticSupplierBeans(Map<String, Supplier<?>> beans) {
        supplierMap = new ConcurrentHashMap(beans);
    }

    public void initRuntimeSupplierBeans(Map<String, Supplier<?>> beans) {
        supplierMap.putAll(beans);
    }

    public BeanContainer initBeanContainer(ArcContainer container, List<BeanContainerListener> listeners) throws Exception {
        if (container == null) {
            throw new IllegalArgumentException("Arc container was null");
        }
        BeanContainerImpl beanContainer = new BeanContainerImpl(container);
        for (BeanContainerListener listener : listeners) {
            listener.created(beanContainer);
        }
        return beanContainer;
    }

    public void handleLifecycleEvents(ShutdownContext context, BeanContainer beanContainer) {
        final LifecycleEventRunner instance = beanContainer.instance(LifecycleEventRunner.class, new Annotation[0]);
        instance.fireStartupEvent();
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                instance.fireShutdownEvent();
            }
        });
    }

    public Supplier<Object> createSupplier(final RuntimeValue<?> value) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return value.getValue();
            }
        };
    }
}

