/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeArgExpression;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeVariableInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public class CodeGenHelper {
    private CodeGenHelper() {
    }

    public static MethodKind methodKind(MethodInfo methodInfo) {
        TypeInfo lastParamType;
        List<ParamInfo> params = methodInfo.getParams();
        int lastParamIndex = params.size() - 1;
        if (lastParamIndex >= 0 && (lastParamType = params.get(lastParamIndex).getType()).getKind() == ClassKind.HANDLER) {
            TypeInfo typeArg = ((ParameterizedTypeInfo)lastParamType).getArgs().get(0);
            if (typeArg.getKind() == ClassKind.ASYNC_RESULT) {
                return MethodKind.FUTURE;
            }
            return MethodKind.HANDLER;
        }
        return MethodKind.OTHER;
    }

    public static String genTypeName(TypeInfo type) {
        if (type.isParameterized()) {
            ParameterizedTypeInfo pt = (ParameterizedTypeInfo)type;
            return CodeGenHelper.genTypeName(pt.getRaw()) + pt.getArgs().stream().map(CodeGenHelper::genTypeName).collect(Collectors.joining(", ", "<", ">"));
        }
        if (type.getKind() == ClassKind.API) {
            return type.translateName("mutiny");
        }
        return type.getSimpleName();
    }

    private static boolean isSameType(TypeInfo type, MethodInfo method) {
        ClassKind kind = type.getKind();
        if (kind.basic || kind.json || kind == ClassKind.DATA_OBJECT || kind == ClassKind.ENUM || kind == ClassKind.OTHER || kind == ClassKind.THROWABLE || kind == ClassKind.VOID) {
            return true;
        }
        if (kind == ClassKind.OBJECT) {
            if (type.isVariable()) {
                return !CodeGenHelper.isReified((TypeVariableInfo)type, method);
            }
            return true;
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.LIST || kind == ClassKind.SET || kind == ClassKind.ASYNC_RESULT) {
                return CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.MAP) {
                return CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
            if (kind == ClassKind.HANDLER) {
                return CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.FUNCTION) {
                return CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(0), method) && CodeGenHelper.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
        }
        return false;
    }

    public static String genConvParam(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, TypeInfo type, MethodInfo method, String expr) {
        ClassKind kind = type.getKind();
        if (CodeGenHelper.isSameType(type, method)) {
            return expr;
        }
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type.isVariable() && (typeArg = CodeGenHelper.genTypeArg((TypeVariableInfo)type, method)) != null) {
                return typeArg + ".<" + type.getName() + ">unwrap(" + expr + ")";
            }
            return expr;
        }
        if (kind == ClassKind.API) {
            return expr + ".getDelegate()";
        }
        if (kind == ClassKind.CLASS_TYPE) {
            return MutinyHelper.class.getName() + ".unwrap(" + expr + ")";
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.HANDLER) {
                TypeInfo eventType = parameterizedTypeInfo.getArg(0);
                ClassKind eventKind = eventType.getKind();
                if (eventKind == ClassKind.ASYNC_RESULT) {
                    TypeInfo resultType = ((ParameterizedTypeInfo)eventType).getArg(0);
                    return "new Handler<AsyncResult<" + resultType.getName() + ">>() {\n      public void handle(AsyncResult<" + resultType.getName() + "> ar) {\n        if (ar.succeeded()) {\n          " + expr + ".handle(io.vertx.core.Future.succeededFuture(" + CodeGenHelper.genConvReturn(methodTypeArgMap, resultType, method, "ar.result()") + "));\n        } else {\n          " + expr + ".handle(io.vertx.core.Future.failedFuture(ar.cause()));\n        }\n      }\n    }";
                }
                return "new Handler<" + eventType.getName() + ">() {\n      public void handle(" + eventType.getName() + " event) {\n        " + expr + ".handle(" + CodeGenHelper.genConvReturn(methodTypeArgMap, eventType, method, "event") + ");\n      }\n    }";
            }
            if (kind == ClassKind.FUNCTION) {
                TypeInfo argType = parameterizedTypeInfo.getArg(0);
                TypeInfo retType = parameterizedTypeInfo.getArg(1);
                return "new java.util.function.Function<" + argType.getName() + "," + retType.getName() + ">() {\n      public " + retType.getName() + " apply(" + argType.getName() + " arg) {\n        " + CodeGenHelper.genTypeName(retType) + " ret = " + expr + ".apply(" + CodeGenHelper.genConvReturn(methodTypeArgMap, argType, method, "arg") + ");\n        return " + CodeGenHelper.genConvParam(methodTypeArgMap, retType, method, "ret") + ";\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + CodeGenHelper.genConvParam(methodTypeArgMap, parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(java.util.stream.Collectors.to" + type.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(java.util.stream.Collectors.toMap(e -> e.getKey(), e -> " + CodeGenHelper.genConvParam(methodTypeArgMap, parameterizedTypeInfo.getArg(1), method, "e.getValue()") + "))";
            }
        }
        return expr;
    }

    private static boolean isReified(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return true;
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        return typeArg != null && typeArg.isClassType();
    }

    private static String genTypeArg(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return "__typeArg_" + typeVar.getParam().getIndex();
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        if (typeArg != null) {
            if (typeArg.isClassType()) {
                return TypeArg.class.getName() + ".of(" + typeArg.getParam().getName() + ")";
            }
            return typeArg.getParam().getName() + ".__typeArg_" + typeArg.getIndex();
        }
        return null;
    }

    public static void genTypeArg(TypeInfo arg, MethodInfo method, int depth, StringBuilder sb) {
        ClassKind argKind = arg.getKind();
        if (argKind == ClassKind.API) {
            sb.append("new ").append(TypeArg.class.getName()).append("<").append(arg.translateName("mutiny")).append(">(o").append(depth).append(" -> ");
            sb.append(arg.getRaw().translateName("mutiny")).append(".newInstance((").append(arg.getRaw()).append(")o").append(depth);
            if (arg instanceof ParameterizedTypeInfo) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)arg;
                List<TypeInfo> args = parameterizedType.getArgs();
                for (int i = 0; i < args.size(); ++i) {
                    sb.append(", ");
                    CodeGenHelper.genTypeArg(args.get(i), method, depth + 1, sb);
                }
            }
            sb.append(")");
            sb.append(", o").append(depth).append(" -> o").append(depth).append(".getDelegate())");
        } else {
            String resolved;
            String typeArg = TypeArg.class.getName() + ".unknown()";
            if (argKind == ClassKind.OBJECT && arg.isVariable() && (resolved = CodeGenHelper.genTypeArg((TypeVariableInfo)arg, method)) != null) {
                typeArg = resolved;
            }
            sb.append(typeArg);
        }
    }

    private static String genTypeArg(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, TypeInfo arg, MethodInfo method) {
        String resolved;
        String typeArgRef;
        Map<TypeInfo, String> typeArgMap = methodTypeArgMap.get(method);
        if (typeArgMap != null && (typeArgRef = typeArgMap.get(arg)) != null) {
            return typeArgRef;
        }
        ClassKind kind = arg.getKind();
        if (kind == ClassKind.API) {
            StringBuilder sb = new StringBuilder();
            CodeGenHelper.genTypeArg(arg, method, 0, sb);
            return sb.toString();
        }
        String typeArg = TypeArg.class.getName() + ".unknown()";
        if (arg.isVariable() && (resolved = CodeGenHelper.genTypeArg((TypeVariableInfo)arg, method)) != null) {
            typeArg = resolved;
        }
        return typeArg;
    }

    public static String genConvReturn(Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap, TypeInfo type, MethodInfo method, String expr) {
        ClassKind kind = type.getKind();
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type.isVariable() && (typeArg = CodeGenHelper.genTypeArg((TypeVariableInfo)type, method)) != null) {
                return "(" + type.getName() + ")" + typeArg + ".wrap(" + expr + ")";
            }
            return "(" + type.getSimpleName() + ") " + expr;
        }
        if (CodeGenHelper.isSameType(type, method)) {
            return expr;
        }
        if (kind == ClassKind.API) {
            StringBuilder tmp = new StringBuilder(type.getRaw().translateName("mutiny"));
            tmp.append(".newInstance(");
            tmp.append(expr);
            if (type.isParameterized()) {
                ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
                for (TypeInfo arg : parameterizedTypeInfo.getArgs()) {
                    tmp.append(", ");
                    tmp.append(CodeGenHelper.genTypeArg(methodTypeArgMap, arg, method));
                }
            }
            tmp.append(")");
            return tmp.toString();
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.HANDLER) {
                TypeInfo abc = parameterizedTypeInfo.getArg(0);
                if (abc.getKind() == ClassKind.ASYNC_RESULT) {
                    TypeInfo tutu = ((ParameterizedTypeInfo)abc).getArg(0);
                    return "new Handler<AsyncResult<" + CodeGenHelper.genTypeName(tutu) + ">>() {\n      public void handle(AsyncResult<" + CodeGenHelper.genTypeName(tutu) + "> ar) {\n        if (ar.succeeded()) {\n          " + expr + ".handle(io.vertx.core.Future.succeededFuture(" + CodeGenHelper.genConvParam(methodTypeArgMap, tutu, method, "ar.result()") + "));\n        } else {\n          " + expr + ".handle(io.vertx.core.Future.failedFuture(ar.cause()));\n        }\n      }\n    }";
                }
                return "new Handler<" + CodeGenHelper.genTypeName(abc) + ">() {\n      public void handle(" + CodeGenHelper.genTypeName(abc) + " event) {\n          " + expr + ".handle(" + CodeGenHelper.genConvParam(methodTypeArgMap, abc, method, "event") + ");\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + CodeGenHelper.genConvReturn(methodTypeArgMap, parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(java.util.stream.Collectors.to" + type.getRaw().getSimpleName() + "())";
            }
        }
        return expr;
    }

    static String genOptTypeParamsDecl(ClassTypeInfo type, String deflt) {
        if (type.getParams().size() > 0) {
            return type.getParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">"));
        }
        return deflt;
    }

    public static String renderLinkToHtml(Tag.Link link) {
        ClassTypeInfo rawType = link.getTargetType().getRaw();
        if (rawType.getModule() != null) {
            String label = link.getLabel().trim();
            if (rawType.getKind() == ClassKind.DATA_OBJECT) {
                return "{@link " + rawType.getName() + "}";
            }
            if (rawType.getKind() == ClassKind.API) {
                Element elt = link.getTargetElement();
                String eltKind = elt.getKind().name();
                String ret = "{@link " + rawType.translateName("mutiny");
                if ("METHOD".equals(eltKind)) {
                    ret = ret + "#" + elt.getSimpleName().toString();
                }
                if (label.length() > 0) {
                    ret = ret + " " + label;
                }
                ret = ret + "}";
                return ret;
            }
        }
        return "{@link " + rawType.getName() + "}";
    }

    public static String renderLinkToHtml(ClassTypeInfo owner, MethodInfo method) {
        if (owner.getModule() != null) {
            if (owner.getKind() == ClassKind.DATA_OBJECT) {
                return "{@link " + owner.getName() + "}";
            }
            if (owner.getKind() == ClassKind.API) {
                String ret = "{@link " + owner.translateName("mutiny");
                ret = ret + "#" + method.getName();
                if (!method.getParams().isEmpty()) {
                    ret = ret + "(" + method.getParams().stream().map(p -> {
                        TypeInfo type = p.getType();
                        if (type.getKind() == ClassKind.API) {
                            return type.translateName("mutiny");
                        }
                        return type.getSimpleName();
                    }).collect(Collectors.joining(",")) + ")";
                }
                ret = ret + "}";
                return ret;
            }
        }
        return "{@link " + owner.getName() + "}";
    }
}

