/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.ui;

import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.vertx.core.http.HttpHeaders;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class StaticContentTest {
    @TestHTTPResource(value="index.html")
    URL url;

    private static String readStream(InputStream in) throws IOException {
        int r;
        byte[] data = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((r = in.read(data)) > 0) {
            out.write(data, 0, r);
        }
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    @Test
    public void testIndexHtml() throws Exception {
        try (InputStream in = this.url.openStream();){
            String contents = StaticContentTest.readStream(in);
            Assertions.assertTrue((boolean)contents.contains("<title>Kogito - TrustyAI</title>"));
        }
    }

    @Test
    public void testHeaders() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/", new Object[0])).then()).statusCode(200)).header(HttpHeaders.CACHE_CONTROL.toString(), "no-cache")).header(HttpHeaders.CONTENT_TYPE.toString(), "text/html;charset=utf8");
    }

    @Test
    public void testHandlePath() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/audit", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/audit/decision/9cf2179f-4fed-4793-b674-a19c45e6cbff/outcomes", new Object[0])).then()).statusCode(200);
    }
}

