/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devconsole.runtime.spi;

import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class FlashScopeUtil {
    private static final String FLASH_COOKIE_NAME = "_flash";
    private static final String FLASH_CONTEXT_DATA_NAME = "flash";

    public static void setFlash(RoutingContext event, Map<String, Object> data) {
        event.response().addCookie(Cookie.cookie(FLASH_COOKIE_NAME, Base64.getEncoder().encodeToString(FlashScopeUtil.marshallMap(data))));
    }

    public static Object getFlash(RoutingContext event) {
        return event.data().get(FLASH_CONTEXT_DATA_NAME);
    }

    public static void handleFlashCookie(RoutingContext event) {
        byte[] decoded;
        byte[] bytes;
        Cookie cookie = event.request().getCookie(FLASH_COOKIE_NAME);
        if (cookie != null && (bytes = cookie.getValue().getBytes()) != null && bytes.length != 0 && (decoded = Base64.getDecoder().decode(bytes)).length > 0) {
            Map<String, Object> data = FlashScopeUtil.unmarshallMap(decoded);
            event.data().put(FLASH_CONTEXT_DATA_NAME, data);
        }
        event.response().removeCookie(FLASH_COOKIE_NAME);
    }

    /*
     * Exception decompiling
     */
    private static byte[] marshallMap(Map<String, Object> data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static Map<String, Object> unmarshallMap(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setFlashMessage(RoutingContext event, String message) {
        FlashScopeUtil.setFlashMessage(event, message, FlashMessageStatus.SUCCESS, null);
    }

    public static void setFlashMessage(RoutingContext event, String message, Duration displayTime) {
        FlashScopeUtil.setFlashMessage(event, message, FlashMessageStatus.SUCCESS, displayTime);
    }

    public static void setFlashMessage(RoutingContext event, String message, FlashMessageStatus messageStatus, Duration displayTime) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, String> messageData = new HashMap<String, String>();
        messageData.put("text", message);
        messageData.put("class", messageStatus.cssClass);
        data.put("message", messageData);
        data.put("displayTime", displayTime != null ? displayTime.toMillis() : 2000L);
        FlashScopeUtil.setFlash(event, data);
    }

    public static enum FlashMessageStatus {
        SUCCESS("success"),
        ERROR("danger");

        public final String cssClass;

        private FlashMessageStatus(String cssClass) {
            this.cssClass = cssClass;
        }
    }
}

