/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import io.smallrye.mutiny.helpers.test.AssertionHelper;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AssertSubscriber<T>
implements Subscriber<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Subscription> subscription = new AtomicReference();
    private final AtomicLong requested = new AtomicLong();
    private final List<T> items = new CopyOnWriteArrayList<T>();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final AtomicBoolean completed = new AtomicBoolean();
    private int numberOfSubscription = 0;
    private final boolean upfrontCancellation;
    private boolean cancelled;

    public AssertSubscriber(long requested, boolean cancelled) {
        this.requested.set(requested);
        this.upfrontCancellation = cancelled;
    }

    public AssertSubscriber() {
        this(0L, false);
    }

    public AssertSubscriber(long requested) {
        this(requested, false);
    }

    public static <T> AssertSubscriber<T> create() {
        return new AssertSubscriber<T>(0L);
    }

    public static <T> AssertSubscriber<T> create(long requested) {
        return new AssertSubscriber<T>(requested);
    }

    public AssertSubscriber<T> assertCompleted() {
        AssertionHelper.shouldHaveCompleted(this.hasCompleted(), this.getFailure(), this.getItems());
        return this;
    }

    public AssertSubscriber<T> assertFailedWith(Class<? extends Throwable> expectedTypeOfFailure, String expectedFailureMessage) {
        AssertionHelper.shouldHaveFailed(this.hasCompleted(), this.getFailure(), expectedTypeOfFailure, expectedFailureMessage);
        return this;
    }

    public AssertSubscriber<T> assertHasNotReceivedAnyItem() {
        AssertionHelper.shouldHaveReceivedNoItems(this.items);
        return this;
    }

    public AssertSubscriber<T> assertSubscribed() {
        AssertionHelper.shouldBeSubscribed(this.numberOfSubscription);
        return this;
    }

    public AssertSubscriber<T> assertNotSubscribed() {
        AssertionHelper.shouldNotBeSubscribed(this.numberOfSubscription);
        return this;
    }

    public AssertSubscriber<T> assertTerminated() {
        AssertionHelper.shouldBeTerminated(this.hasCompleted(), this.getFailure());
        return this;
    }

    public AssertSubscriber<T> assertNotTerminated() {
        AssertionHelper.shouldNotBeTerminated(this.hasCompleted(), this.getFailure());
        return this;
    }

    @SafeVarargs
    public final AssertSubscriber<T> assertItems(T ... expected) {
        AssertionHelper.shouldHaveReceivedExactly(this.items, expected);
        return this;
    }

    public AssertSubscriber<T> await() {
        return this.await(Duration.ofSeconds(10L));
    }

    public AssertSubscriber<T> await(Duration duration) {
        if (this.latch.getCount() == 0L) {
            return this;
        }
        try {
            if (!this.latch.await(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)"Expected a terminal event before the timeout.");
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public AssertSubscriber<T> cancel() {
        AssertionHelper.shouldBeSubscribed(this.numberOfSubscription);
        this.subscription.get().cancel();
        this.cancelled = true;
        return this;
    }

    public AssertSubscriber<T> request(long req) {
        this.requested.addAndGet(req);
        if (this.subscription.get() != null) {
            this.subscription.get().request(req);
        }
        return this;
    }

    @Override
    public void onSubscribe(Subscription s) {
        ++this.numberOfSubscription;
        this.subscription.set(s);
        if (this.upfrontCancellation) {
            s.cancel();
            this.cancelled = true;
            return;
        }
        if (this.requested.get() > 0L) {
            s.request(this.requested.get());
        }
    }

    @Override
    public synchronized void onNext(T t) {
        this.items.add(t);
    }

    @Override
    public void onError(Throwable t) {
        this.failure.set(t);
        this.latch.countDown();
    }

    @Override
    public void onComplete() {
        this.completed.set(true);
        this.latch.countDown();
    }

    public List<T> getItems() {
        return this.items;
    }

    public Throwable getFailure() {
        return this.failure.get();
    }

    public AssertSubscriber<T> run(Runnable action) {
        try {
            action.run();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean hasCompleted() {
        return this.completed.get();
    }
}

