/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.AccessorCandidate;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.FieldAccessor;
import io.quarkus.qute.GetterAccessor;
import io.quarkus.qute.MemberKey;
import io.quarkus.qute.MethodsCandidate;
import io.quarkus.qute.Results;
import io.quarkus.qute.ValueAccessor;
import io.quarkus.qute.ValueResolver;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReflectionValueResolver
implements ValueResolver {
    private final ConcurrentMap<MemberKey, Optional<AccessorCandidate>> candidates = new ConcurrentHashMap<MemberKey, Optional<AccessorCandidate>>();
    private static final AccessorCandidate ARRAY_GET_LENGTH = ec -> instance -> CompletableFuture.completedFuture(Array.getLength(instance));
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String HAS_PREFIX = "has";

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public boolean appliesTo(EvalContext context) {
        Object base = context.getBase();
        if (base == null) {
            return false;
        }
        return this.candidates.computeIfAbsent(MemberKey.from(base, context.getName(), context.getParams().size()), this::findCandidate).isPresent();
    }

    @Override
    public CompletionStage<Object> resolve(EvalContext context) {
        Object base = context.getBase();
        MemberKey key = MemberKey.from(base, context.getName(), context.getParams().size());
        AccessorCandidate candidate = ((Optional)this.candidates.get(key)).orElse(null);
        if (candidate == null) {
            return Results.NOT_FOUND;
        }
        ValueAccessor accessor2 = candidate.getAccessor(context);
        if (accessor2 == null) {
            return Results.NOT_FOUND;
        }
        return accessor2.getValue(base);
    }

    public void clearCache() {
        this.candidates.clear();
    }

    private Optional<AccessorCandidate> findCandidate(MemberKey key) {
        if (key.clazz.isArray()) {
            if (key.name.equals("length") && key.numberOfParams == 0) {
                return Optional.of(ARRAY_GET_LENGTH);
            }
            return Optional.empty();
        }
        if (key.numberOfParams > 0) {
            List<Method> methods = ReflectionValueResolver.findMethods(key.clazz, key.name, key.numberOfParams);
            return methods.isEmpty() ? Optional.empty() : Optional.of(new MethodsCandidate(methods));
        }
        Method foundMethod = this.findMethodNoArgs(key.clazz, key.name);
        if (foundMethod != null) {
            foundMethod.trySetAccessible();
            return Optional.of(new GetterAccessor(foundMethod));
        }
        Field foundField = this.findField(key.clazz, key.name);
        if (foundField != null) {
            foundField.trySetAccessible();
            return Optional.of(new FieldAccessor(foundField));
        }
        return Optional.empty();
    }

    private Method findMethodNoArgs(Class<?> clazz, String name) {
        Method foundMatch = null;
        Method foundGetterMatch = null;
        Method foundBooleanMatch = null;
        ArrayList classes = new ArrayList();
        Collections.addAll(classes, clazz.getInterfaces());
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            Collections.addAll(classes, superClass.getInterfaces());
        }
        classes.add(clazz);
        for (Class clazz2 : classes) {
            for (Method method : clazz2.getMethods()) {
                if (!ReflectionValueResolver.isMethodValid(method) || method.isBridge()) continue;
                if (name.equals(method.getName())) {
                    foundMatch = method;
                    continue;
                }
                if (ReflectionValueResolver.matchesPrefix(name, method.getName(), GET_PREFIX)) {
                    foundGetterMatch = method;
                    continue;
                }
                if (!ReflectionValueResolver.isBoolean(method.getReturnType()) || !ReflectionValueResolver.matchesPrefix(name, method.getName(), IS_PREFIX) && !ReflectionValueResolver.matchesPrefix(name, method.getName(), HAS_PREFIX)) continue;
                foundBooleanMatch = method;
            }
            if (foundMatch == null) {
                Method method = foundMatch = foundGetterMatch != null ? foundGetterMatch : foundBooleanMatch;
            }
            if (foundMatch == null) continue;
            break;
        }
        return foundMatch;
    }

    private Field findField(Class<?> clazz, String name) {
        Field found = null;
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            found = field;
        }
        return found;
    }

    private static List<Method> findMethods(Class<?> clazz, String name, int numberOfParams) {
        ArrayList<Method> foundMatch = new ArrayList<Method>();
        ArrayList hierarchy = new ArrayList();
        Collections.addAll(hierarchy, clazz.getInterfaces());
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            Collections.addAll(hierarchy, superClass.getInterfaces());
        }
        hierarchy.add(clazz);
        for (Class clazz2 : hierarchy) {
            for (Method method : clazz2.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !method.isVarArgs() && method.getParameterCount() != numberOfParams || method.getReturnType().equals(Void.TYPE) || Object.class.equals(method.getDeclaringClass()) || method.isBridge() || !name.equals(method.getName())) continue;
                foundMatch.add(method);
                method.trySetAccessible();
            }
        }
        return foundMatch.size() == 1 ? Collections.singletonList((Method)foundMatch.get(0)) : foundMatch;
    }

    private static boolean isMethodValid(Method method) {
        return method != null && Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE) && !Object.class.equals(method.getDeclaringClass());
    }

    private static boolean matchesPrefix(String name, String methodName, String prefix) {
        return methodName.startsWith(prefix) && ReflectionValueResolver.decapitalize(methodName.substring(prefix.length(), methodName.length())).equals(name);
    }

    private static boolean isBoolean(Class<?> type) {
        return type.equals(Boolean.class) || type.equals(Boolean.TYPE);
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

