/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.common.runtime.jsonb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.activation.DataSource;
import javax.annotation.Priority;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.FileRange;
import org.jboss.resteasy.plugins.providers.jsonb.JsonBindingProvider;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.AsyncStreamingOutput;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
@Priority(value=4800)
public class QuarkusJsonbSerializer
extends JsonBindingProvider {
    private static final Set<Class<?>> BUILTIN_DEFAULTS = new HashSet<Class>(Arrays.asList(String.class, InputStream.class, FileRange.class, AsyncStreamingOutput.class, DataSource.class, Reader.class, StreamingOutput.class, byte[].class, File.class));

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (BUILTIN_DEFAULTS.contains(type)) {
            return false;
        }
        return QuarkusJsonbSerializer.isSupportedMediaType((MediaType)mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (BUILTIN_DEFAULTS.contains(type)) {
            return false;
        }
        return QuarkusJsonbSerializer.isSupportedMediaType((MediaType)mediaType) || mediaType.equals(MediaType.APPLICATION_OCTET_STREAM_TYPE) || mediaType.isWildcardType();
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        httpHeaders.putSingle("Content-Type", "application/json");
        super.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public CompletionStage<Void> asyncWriteTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        httpHeaders.putSingle("Content-Type", "application/json");
        return super.asyncWriteTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }
}

