/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.server.common.runtime;

import io.quarkus.runtime.test.TestHttpEndpointProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.Path;
import org.eclipse.microprofile.config.ConfigProvider;

public class RESTEasyTestHttpProvider
implements TestHttpEndpointProvider {
    @Override
    public Function<Class<?>, String> endpointProvider() {
        return new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> aClass) {
                Object value = RESTEasyTestHttpProvider.this.getPath(aClass);
                if (value == null) {
                    return null;
                }
                if (((String)value).startsWith("/")) {
                    value = ((String)value).substring(1);
                }
                Object path = "/";
                Optional<String> appPath = ConfigProvider.getConfig().getOptionalValue("quarkus.resteasy.path", String.class);
                if (appPath.isPresent()) {
                    path = appPath.get();
                }
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                value = (String)path + (String)value;
                return value;
            }
        };
    }

    private String getPath(Class<?> aClass) {
        String value = null;
        for (Annotation annotation : aClass.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(Path.class.getName())) continue;
            try {
                value = (String)annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                break;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (value == null) {
            Object i;
            Object[] objectArray = aClass.getInterfaces();
            int n = objectArray.length;
            for (int j = 0; j < n && (value = this.getPath((Class<?>)(i = objectArray[j]))) == null; ++j) {
            }
        }
        if (value == null && aClass.getSuperclass() != Object.class) {
            value = this.getPath(aClass.getSuperclass());
        }
        return value;
    }
}

