/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.OrAuthorization;
import io.vertx.ext.auth.authorization.impl.AuthorizationConverter;
import java.util.Objects;

public class OrAuthorizationConverter {
    private static final String FIELD_TYPE = "type";
    private static final String TYPE_AND_AUTHORIZATION = "or";
    private static final String FIELD_AUTHORIZATIONS = "authorizations";

    public static JsonObject encode(OrAuthorization value) throws IllegalArgumentException {
        Objects.requireNonNull(value);
        JsonObject result = new JsonObject();
        result.put(FIELD_TYPE, TYPE_AND_AUTHORIZATION);
        JsonArray authorizations = new JsonArray();
        result.put(FIELD_AUTHORIZATIONS, authorizations);
        for (Authorization authorization : value.getAuthorizations()) {
            authorizations.add(AuthorizationConverter.encode(authorization));
        }
        return result;
    }

    public static OrAuthorization decode(JsonObject json) throws IllegalArgumentException {
        Objects.requireNonNull(json);
        if (TYPE_AND_AUTHORIZATION.equals(json.getString(FIELD_TYPE))) {
            OrAuthorization result = OrAuthorization.create();
            JsonArray authorizations = json.getJsonArray(FIELD_AUTHORIZATIONS);
            for (int i = 0; i < authorizations.size(); ++i) {
                JsonObject authorization = authorizations.getJsonObject(i);
                result.addAuthorization(AuthorizationConverter.decode(authorization));
            }
            return result;
        }
        return null;
    }
}

