/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core;

import java.util.Arrays;
import org.kie.hacep.Config;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.core.CoreKube;
import org.kie.hacep.core.GlobalStatus;
import org.kie.hacep.core.infra.consumer.ConsumerController;
import org.kie.hacep.core.infra.election.LeaderElection;
import org.kie.remote.impl.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger logger = LoggerFactory.getLogger(Bootstrap.class);
    private static Producer eventProducer;
    private static ConsumerController consumerController;
    private static CoreKube coreKube;

    public static void startEngine(EnvConfig envConfig) {
        Bootstrap.checkKJarVersion(envConfig);
        if (!envConfig.isUnderTest()) {
            coreKube = new CoreKube(envConfig.getNamespace(), null);
        }
        eventProducer = Bootstrap.startProducer(envConfig);
        Bootstrap.startConsumers(envConfig, eventProducer);
        if (!envConfig.isUnderTest()) {
            Bootstrap.leaderElection();
        }
        GlobalStatus.nodeReady = true;
        logger.info("CONFIGURE on start engine:{}", (Object)envConfig);
    }

    public static void stopEngine() {
        logger.info("Stop engine");
        if (coreKube != null && coreKube.getLeaderElection() != null) {
            LeaderElection leadership = coreKube.getLeaderElection();
            try {
                leadership.stop();
            }
            catch (Exception e) {
                GlobalStatus.nodeLive = false;
                throw new RuntimeException(e.getMessage(), e);
            }
            logger.info("Stop leaderElection");
        }
        if (consumerController != null) {
            consumerController.stop();
        }
        logger.info("Stop consumerController");
        if (eventProducer != null) {
            eventProducer.stop();
        }
        logger.info("Stop eventProducer");
        eventProducer = null;
        consumerController = null;
        GlobalStatus.nodeLive = false;
    }

    public static ConsumerController getConsumerController() {
        return consumerController;
    }

    private static void leaderElection() {
        LeaderElection leadership = coreKube.getLeaderElection();
        coreKube.getLeaderElection().addCallbacks(Arrays.asList(consumerController.getCallback()));
        try {
            leadership.start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static Producer startProducer(EnvConfig envConfig) {
        Producer producer = Producer.get((boolean)envConfig.isLocal());
        producer.start(Config.getProducerConfig("EventProducer"));
        return producer;
    }

    private static void startConsumers(EnvConfig envConfig, Producer producer) {
        consumerController = new ConsumerController(envConfig, producer);
        consumerController.start();
    }

    private static void checkKJarVersion(EnvConfig envConfig) {
        if (envConfig.isUpdatableKJar()) {
            String gav = envConfig.getKJarGAV();
            if (gav == null) {
                throw new RuntimeException("The KJar GAV is missing and must be in the format groupdID:artifactID:version");
            }
            String[] parts = gav.split(":");
            if (parts.length != 3) {
                throw new RuntimeException("The KJar GAV must be in the format groupdID:artifactID:version");
            }
        }
    }
}

