/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.kie.api.KieServices;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.hacep.Config;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.KieContainerUtils;
import org.kie.hacep.core.KieSessionContext;
import org.kie.hacep.core.infra.SessionSnapshooter;
import org.kie.hacep.core.infra.SnapshotInfos;
import org.kie.hacep.message.SnapshotMessage;
import org.kie.remote.impl.producer.EventProducer;
import org.kie.remote.message.Message;
import org.kie.remote.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSessionSnapShooter
implements SessionSnapshooter {
    private final String key = "LAST-SNAPSHOT";
    private final Logger logger = LoggerFactory.getLogger(DefaultSessionSnapShooter.class);
    private EnvConfig envConfig;

    public DefaultSessionSnapShooter(EnvConfig envConfig) {
        this.envConfig = envConfig;
    }

    @Override
    public void serialize(KieSessionContext kieSessionContext, String lastInsertedEventkey, long lastInsertedEventOffset) {
        KieMarshallers marshallers = KieServices.get().getMarshallers();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            EventProducer producer = new EventProducer();
            producer.start(Config.getSnapshotProducerConfig());
            marshallers.newMarshaller(kieSessionContext.getKieSession().getKieBase()).marshall((OutputStream)out, kieSessionContext.getKieSession());
            byte[] bytes = out.toByteArray();
            SnapshotMessage message = new SnapshotMessage(UUID.randomUUID().toString(), this.envConfig.getKJarGAV(), bytes, kieSessionContext.getFhManager(), lastInsertedEventkey, lastInsertedEventOffset, LocalDateTime.now());
            producer.produceSync(this.envConfig.getSnapshotTopicName(), "LAST-SNAPSHOT", (Message)message);
            producer.stop();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public SnapshotInfos deserialize() {
        KieServices srv = KieServices.get();
        if (srv != null) {
            SnapshotMessage snapshotMsg;
            KafkaConsumer consumer = this.getConfiguredSnapshotConsumer();
            ConsumerRecords records = consumer.poll(this.envConfig.getPollSnapshotDuration());
            byte[] bytes = null;
            for (ConsumerRecord record : records) {
                bytes = (byte[])record.value();
            }
            consumer.close();
            SnapshotMessage snapshotMessage = snapshotMsg = bytes != null ? (SnapshotMessage)SerializationUtil.deserialize(bytes) : null;
            if (snapshotMsg != null) {
                KieContainer kieContainer = null;
                KieSession kSession = null;
                try (ByteArrayInputStream in = new ByteArrayInputStream(snapshotMsg.getSerializedSession());){
                    KieSessionConfiguration conf = srv.newKieSessionConfiguration();
                    conf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
                    kieContainer = KieContainerUtils.getKieContainer(this.envConfig, srv);
                    kSession = srv.getMarshallers().newMarshaller(kieContainer.getKieBase()).unmarshall((InputStream)in, conf, null);
                }
                catch (IOException | ClassNotFoundException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                if (kSession == null) {
                    kSession = kieContainer.newKieSession();
                }
                return new SnapshotInfos(kSession, kieContainer, snapshotMsg.getFhManager(), snapshotMsg.getLastInsertedEventkey(), snapshotMsg.getLastInsertedEventOffset(), snapshotMsg.getTime(), snapshotMsg.getKjarGAV());
            }
        } else {
            throw new RuntimeException("KieServices is null");
        }
        return null;
    }

    private KafkaConsumer getConfiguredSnapshotConsumer() {
        KafkaConsumer consumer = new KafkaConsumer(Config.getSnapshotConsumerConfig());
        List partitionsInfo = consumer.partitionsFor(this.envConfig.getSnapshotTopicName());
        List partitions = null;
        ArrayList<TopicPartition> partitionCollection = new ArrayList<TopicPartition>();
        if (partitionsInfo != null) {
            for (PartitionInfo partition : partitionsInfo) {
                TopicPartition topicPartition2 = new TopicPartition(partition.topic(), partition.partition());
                if (partitions != null && !partitions.contains(topicPartition2)) continue;
                partitionCollection.add(topicPartition2);
            }
            if (!partitionCollection.isEmpty()) {
                consumer.assign(partitionCollection);
            }
        }
        consumer.assignment().forEach(topicPartition -> consumer.seekToBeginning(partitionCollection));
        return consumer;
    }

    @Override
    public LocalDateTime getLastSnapshotTime() {
        SnapshotMessage snapshotMsg;
        KafkaConsumer consumer = this.getConfiguredSnapshotConsumer();
        ConsumerRecords records = consumer.poll(this.envConfig.getPollSnapshotDuration());
        byte[] bytes = null;
        for (ConsumerRecord record : records) {
            bytes = (byte[])record.value();
        }
        consumer.close();
        SnapshotMessage snapshotMessage = snapshotMsg = bytes != null ? (SnapshotMessage)SerializationUtil.deserialize(bytes) : null;
        if (snapshotMsg != null) {
            return snapshotMsg.getTime();
        }
        return null;
    }
}

