/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetManager {
    private static Logger logger = LoggerFactory.getLogger(OffsetManager.class);
    private static Map<TopicPartition, Long> controlTopicOffset = Collections.emptyMap();
    private static Map<TopicPartition, Long> eventsTopicOffset = Collections.emptyMap();

    public static void saveControlTopic(Map<TopicPartition, Long> newOffset) {
        controlTopicOffset = newOffset;
    }

    public static void saveEventsTopic(Map<TopicPartition, Long> newOffset) {
        eventsTopicOffset = newOffset;
    }

    public static Map<TopicPartition, Long> getControlTopicOffset() {
        return controlTopicOffset;
    }

    public static Map<TopicPartition, Long> getEventsTopicOffset() {
        return eventsTopicOffset;
    }

    public static Properties load() {
        Properties prop = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream("/tmp/offsets.properties");
            prop = new Properties();
            prop.load(input);
        }
        catch (IOException e) {
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Map<TopicPartition, OffsetAndMetadata> offsetAndMetadataMap) {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream("/tmp/offsets.properties");
            for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsetAndMetadataMap.entrySet()) {
                prop.setProperty(entry.getKey().topic() + "-" + entry.getKey().partition(), String.valueOf(entry.getValue().offset()));
            }
            prop.store(output, null);
        }
        catch (IOException io) {
            logger.error(io.getMessage(), (Throwable)io);
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

