/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.consumer;

import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.runtime.KieContainer;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.util.GAVUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieContainerUtils {
    private static final Logger logger = LoggerFactory.getLogger(KieContainerUtils.class);

    public static KieContainer getKieContainer(EnvConfig envConfig, KieServices srv) {
        if (srv != null) {
            KieContainer kieContainer;
            if (envConfig.isUpdatableKJar()) {
                kieContainer = srv.newKieContainer(GAVUtils.getReleaseID(envConfig.getKJarGAV(), srv));
                KieScanner scanner = srv.newKieScanner(kieContainer);
                scanner.scanNow();
                if (logger.isInfoEnabled()) {
                    logger.info("Created new KieContainer with KJar:{} from maven repo", (Object)envConfig.getKJarGAV());
                }
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("Creating new Kie Session with the KJar deployed with the app");
                }
                kieContainer = srv.newKieClasspathContainer();
            }
            return kieContainer;
        }
        throw new RuntimeException("KieServices is null");
    }
}

