/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.consumer;

import org.kie.hacep.EnvConfig;
import org.kie.hacep.core.infra.consumer.ConsumerHandler;
import org.kie.hacep.core.infra.consumer.EventConsumer;
import org.kie.hacep.core.infra.election.State;
import org.kie.remote.DroolsExecutor;
import org.kie.remote.command.RemoteCommand;
import org.kie.remote.util.LocalMessageSystem;

public class LocalConsumer
implements EventConsumer {
    private final LocalMessageSystem queue = LocalMessageSystem.get();
    private final EnvConfig envConfig;
    private ConsumerHandler consumerHandler;
    private State currentState;

    public LocalConsumer(EnvConfig config) {
        this.envConfig = config;
    }

    @Override
    public void initConsumer(ConsumerHandler consumerHandler) {
        this.consumerHandler = consumerHandler;
    }

    @Override
    public void poll() {
        RemoteCommand command;
        String topic = this.envConfig.getEventsTopicName();
        while ((command = (RemoteCommand)this.queue.poll(topic, this.envConfig.getPollTimeout())) != null) {
            this.consumerHandler.process(command, this.currentState);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public synchronized void updateStatus(State state) {
        this.currentState = state;
        if (state == State.REPLICA) {
            DroolsExecutor.setAsReplica();
        } else {
            DroolsExecutor.setAsLeader();
        }
    }
}

