/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.core.Bootstrap;
import org.kie.hacep.core.infra.election.State;
import org.kie.hacep.sample.kjar.Result;
import org.kie.hacep.sample.kjar.StockTickEvent;
import org.kie.remote.CommonConfig;
import org.kie.remote.RemoteEntryPoint;
import org.kie.remote.RemoteFactHandle;
import org.kie.remote.RemoteKieSession;

public class LocalStorageKieSessionTest {
    RemoteKieSession session;

    @Before
    public void initTest() {
        EnvConfig config = EnvConfig.getDefaultEnvConfig().underTest(true).local(true);
        Bootstrap.startEngine((EnvConfig)config);
        Bootstrap.getConsumerController().getCallback().updateStatus(State.LEADER);
        this.session = RemoteKieSession.create((Properties)CommonConfig.getTestProperties());
    }

    @After
    public void endTest() throws IOException {
        this.session.close();
        Bootstrap.stopEngine();
    }

    @Test(timeout=10000L)
    public void insertTest() throws ExecutionException, InterruptedException {
        Assert.assertEquals((Object)0L, this.session.getFactCount().get());
        Assert.assertEquals((Object)0L, this.session.fireAllRules().get());
        RemoteFactHandle resultRFH = this.session.insert((Object)new Result("RHT"));
        Assert.assertEquals((Object)0L, this.session.fireAllRules().get());
        RemoteFactHandle stockRFH = this.session.insert((Object)new StockTickEvent("RHT", 9.0));
        this.session.insert((Object)new StockTickEvent("RHT", 14.0));
        Assert.assertFalse((boolean)((StockTickEvent)this.session.getObject(stockRFH).get()).isProcessed());
        Assert.assertEquals((Object)3L, this.session.getFactCount().get());
        Assert.assertEquals((Object)3L, this.session.fireAllRules().get());
        Assert.assertTrue((boolean)((StockTickEvent)this.session.getObject(stockRFH).get()).isProcessed());
        Assert.assertEquals((Object)11.5, (Object)((Result)this.session.getObject(resultRFH).get()).getValue());
    }

    @Test(timeout=10000L)
    public void updateTest() throws ExecutionException, InterruptedException {
        Assert.assertEquals((Object)0L, this.session.getFactCount().get());
        Assert.assertEquals((Object)0L, this.session.fireAllRules().get());
        StockTickEvent stock = new StockTickEvent("RHT", 9.0);
        RemoteFactHandle stockRFH = this.session.insert((Object)stock);
        Assert.assertFalse((boolean)((StockTickEvent)this.session.getObject(stockRFH).get()).isProcessed());
        Assert.assertEquals((Object)1L, this.session.fireAllRules().get());
        Assert.assertTrue((boolean)((StockTickEvent)this.session.getObject(stockRFH).get()).isProcessed());
        stock.setPrice(10.0);
        this.session.update(stockRFH, (Object)stock);
        Assert.assertEquals((double)stock.getPrice(), (double)((StockTickEvent)this.session.getObject(stockRFH).get()).getPrice(), (double)0.1);
    }

    @Test(timeout=10000L)
    public void deleteTest() throws ExecutionException, InterruptedException {
        Assert.assertEquals((Object)0L, this.session.getFactCount().get());
        Assert.assertEquals((Object)0L, this.session.fireAllRules().get());
        StockTickEvent stock = new StockTickEvent("RHT", 9.0);
        RemoteFactHandle stockRFH = this.session.insert((Object)stock);
        Assert.assertFalse((boolean)((StockTickEvent)this.session.getObject(stockRFH).get()).isProcessed());
        Assert.assertEquals((Object)1L, this.session.fireAllRules().get());
        Assert.assertTrue((boolean)((StockTickEvent)this.session.getObject(stockRFH).get()).isProcessed());
        Assert.assertEquals((Object)1L, this.session.getFactCount().get());
        this.session.delete(stockRFH);
        Assert.assertEquals((Object)0L, this.session.getFactCount().get());
    }

    @Test(timeout=10000L)
    public void fireUntilHaltTest() throws ExecutionException, InterruptedException {
        Assert.assertEquals((Object)0L, this.session.getFactCount().get());
        this.session.fireUntilHalt();
        StockTickEvent stock1 = new StockTickEvent("RHT", 9.0);
        Assert.assertFalse((boolean)stock1.isProcessed());
        RemoteFactHandle stock1RFH = this.session.insert((Object)stock1);
        Assert.assertTrue((boolean)((StockTickEvent)this.session.getObject(stock1RFH).get()).isProcessed());
        this.session.halt();
        StockTickEvent stock2 = new StockTickEvent("RHT", 11.0);
        Assert.assertFalse((boolean)stock2.isProcessed());
        RemoteFactHandle stock2RFH = this.session.insert((Object)stock2);
        Assert.assertFalse((boolean)((StockTickEvent)this.session.getObject(stock2RFH).get()).isProcessed());
        Assert.assertEquals((Object)1L, this.session.fireAllRules().get());
        Assert.assertTrue((boolean)((StockTickEvent)this.session.getObject(stock2RFH).get()).isProcessed());
    }

    @Test(timeout=10000L)
    public void getCommandsTest() throws ExecutionException, InterruptedException {
        RemoteFactHandle stock1FH = this.session.insert((Object)new StockTickEvent("RHT", 9.0));
        this.session.insert((Object)new StockTickEvent("RHT", 19.0));
        Collection getObjectsByClass = (Collection)this.session.getObjects(StockTickEvent.class).get();
        Assert.assertEquals((long)2L, (long)getObjectsByClass.size());
        Collection getObjects = (Collection)this.session.getObjects().get();
        Assert.assertEquals((long)2L, (long)getObjects.size());
        CompletableFuture getObjectByQueryIBM = this.session.getObjects("stockTickEventQuery", "stock", new Object[]{"IBM"});
        Assert.assertEquals((long)0L, (long)((Collection)getObjectByQueryIBM.get()).size());
        CompletableFuture getObjectsByQueryRHT = this.session.getObjects("stockTickEventQuery", "stock", new Object[]{"RHT"});
        Assert.assertEquals((long)2L, (long)((Collection)getObjectsByQueryRHT.get()).size());
        Assert.assertEquals((Object)"RHT", (Object)((StockTickEvent)this.session.getObject(stock1FH).get()).getCompany());
        RemoteEntryPoint defaultEntryPoint = this.session.getEntryPoint("DEFAULT");
        Assert.assertEquals((Object)2L, defaultEntryPoint.getFactCount().get());
        Assert.assertEquals((Object)"DEFAULT", (Object)defaultEntryPoint.getEntryPointId());
    }
}

