/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.core.Bootstrap;
import org.kie.hacep.core.infra.election.State;
import org.kie.hacep.sample.kjar.Result;
import org.kie.hacep.sample.kjar.StockTickEvent;
import org.kie.remote.CommonConfig;
import org.kie.remote.RemoteStreamingEntryPoint;
import org.kie.remote.RemoteStreamingKieSession;

public class LocalStorageStreamingKieSessionTest {
    RemoteStreamingKieSession session;

    @Before
    public void initTest() {
        EnvConfig config = EnvConfig.getDefaultEnvConfig().underTest(true).local(true);
        Bootstrap.startEngine((EnvConfig)config);
        Bootstrap.getConsumerController().getCallback().updateStatus(State.LEADER);
        this.session = RemoteStreamingKieSession.create((Properties)CommonConfig.getTestProperties());
    }

    @After
    public void endTest() throws IOException {
        this.session.close();
        Bootstrap.stopEngine();
    }

    @Test(timeout=10000L)
    public void insertTest() throws ExecutionException, InterruptedException {
        Assert.assertEquals((Object)0L, this.session.getFactCount().get());
        this.session.insert((Object)new Result("RHT"));
        this.session.insert((Object)new StockTickEvent("RHT", 9.0));
        this.session.insert((Object)new StockTickEvent("RHT", 14.0));
        Assert.assertEquals((long)3L, (long)((Collection)this.session.getObjects().get()).size());
        Assert.assertEquals((Object)3L, this.session.getFactCount().get());
        Assert.assertEquals((Object)11.5, (Object)((Result)((Collection)this.session.getObjects(Result.class).get()).iterator().next()).getValue());
    }

    @Test(timeout=10000L)
    public void fireUntilHaltTest() throws ExecutionException, InterruptedException {
        Assert.assertEquals((Object)0L, this.session.getFactCount().get());
        StockTickEvent stock1 = new StockTickEvent("RHT", 9.0);
        Assert.assertFalse((boolean)stock1.isProcessed());
        this.session.insert((Object)stock1);
        Assert.assertTrue((boolean)((StockTickEvent)((Collection)this.session.getObjects(StockTickEvent.class).get()).iterator().next()).isProcessed());
        this.session.halt();
        StockTickEvent stock2 = new StockTickEvent("RHT", 11.0);
        Assert.assertFalse((boolean)stock2.isProcessed());
        this.session.insert((Object)stock2);
        Assert.assertEquals((long)1L, (long)((Collection)this.session.getObjects(StockTickEvent.class).get()).stream().filter(stock -> !stock.isProcessed()).count());
        Assert.assertEquals((Object)1L, this.session.fireAllRules().get());
        Assert.assertEquals((long)0L, (long)((Collection)this.session.getObjects(StockTickEvent.class).get()).stream().filter(stock -> !stock.isProcessed()).count());
    }

    @Test(timeout=10000L)
    public void getCommandsTest() throws ExecutionException, InterruptedException {
        this.session.insert((Object)new StockTickEvent("RHT", 9.0));
        this.session.insert((Object)new StockTickEvent("RHT", 19.0));
        Collection getObjectsByClass = (Collection)this.session.getObjects(StockTickEvent.class).get();
        Assert.assertEquals((long)2L, (long)getObjectsByClass.size());
        Collection getObjects = (Collection)this.session.getObjects().get();
        Assert.assertEquals((long)2L, (long)getObjects.size());
        CompletableFuture getObjectByQueryIBM = this.session.getObjects("stockTickEventQuery", "stock", new Object[]{"IBM"});
        Assert.assertEquals((long)0L, (long)((Collection)getObjectByQueryIBM.get()).size());
        CompletableFuture getObjectsByQueryRHT = this.session.getObjects("stockTickEventQuery", "stock", new Object[]{"RHT"});
        Assert.assertEquals((long)2L, (long)((Collection)getObjectsByQueryRHT.get()).size());
        RemoteStreamingEntryPoint defaultEntryPoint = this.session.getEntryPoint("DEFAULT");
        Assert.assertEquals((Object)2L, defaultEntryPoint.getFactCount().get());
        Assert.assertEquals((Object)"DEFAULT", (Object)defaultEntryPoint.getEntryPointId());
    }
}

