/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.KieContainerUtils;
import org.kie.hacep.core.KieSessionContext;
import org.kie.hacep.util.GAVUtils;
import org.kie.scanner.KieMavenRepository;

public class UpdatableKieSessionTest {
    private KieSessionContext ksCtx;
    private KieSession kieSession;
    private KieContainer kieContainer;
    private final String gav = "org.kie:sample-hacep-project-kjar:800.Final";
    private final String updatedGav = "org.kie:sample-hacep-project-kjar:900.Final";
    private KieServices ks;

    @Before
    public void init() throws Exception {
        this.ks = KieServices.get();
        String drl1 = new String(Files.readAllBytes(Paths.get("target/test-classes/drl1.drl", new String[0])));
        String drl2 = new String(Files.readAllBytes(Paths.get("target/test-classes/drl2.drl", new String[0])));
        this.createAndDeployKJar(GAVUtils.getReleaseID((String)"org.kie:sample-hacep-project-kjar:800.Final", (KieServices)KieServices.get()), Collections.singletonMap("src/main/resources/org/pkg1/r0.drl", drl1));
        this.createAndDeployKJar(GAVUtils.getReleaseID((String)"org.kie:sample-hacep-project-kjar:900.Final", (KieServices)KieServices.get()), Collections.singletonMap("src/main/resources/org/pkg1/r0.drl", drl2));
        this.ksCtx = new KieSessionContext();
    }

    private void initSessionContextFromEmbeddKjar() {
        EnvConfig envConfig = EnvConfig.getDefaultEnvConfig();
        this.kieContainer = KieContainerUtils.getKieContainer((EnvConfig)envConfig, (KieServices)this.ks);
        this.kieSession = this.kieContainer.newKieSession();
        this.ksCtx.init(this.kieContainer, this.kieSession);
    }

    private void initSessionContextFromSpecificKjar() {
        EnvConfig envConfig = EnvConfig.getDefaultEnvConfig();
        envConfig.withUpdatableKJar("true");
        envConfig.withKJarGAV("org.kie:sample-hacep-project-kjar:800.Final");
        envConfig.skipOnDemandSnapshot("true");
        this.kieContainer = KieContainerUtils.getKieContainer((EnvConfig)envConfig, (KieServices)this.ks);
        this.kieSession = this.kieContainer.newKieSession();
        this.ksCtx.init(this.kieContainer, this.kieSession);
    }

    @Test
    public void testEmbeddedKJar() {
        this.initSessionContextFromEmbeddKjar();
        Optional gavUSed = this.ksCtx.getKjarGAVUsed();
        Assert.assertFalse((boolean)gavUSed.isPresent());
    }

    @Test
    public void testWithSpecificKJar() {
        this.initSessionContextFromSpecificKjar();
        Optional gavUSed = this.ksCtx.getKjarGAVUsed();
        Assert.assertTrue((boolean)gavUSed.isPresent());
        Assert.assertEquals(gavUSed.get(), (Object)"org.kie:sample-hacep-project-kjar:800.Final");
    }

    @Test
    public void testUpdateWithSpecificKJar() {
        this.initSessionContextFromSpecificKjar();
        Optional gavUSed = this.ksCtx.getKjarGAVUsed();
        Assert.assertTrue((boolean)gavUSed.isPresent());
        Assert.assertEquals(gavUSed.get(), (Object)"org.kie:sample-hacep-project-kjar:800.Final");
        ReleaseId releaseId = GAVUtils.getReleaseID((String)"org.kie:sample-hacep-project-kjar:900.Final", (KieServices)this.ks);
        this.ksCtx.getKieContainer().updateToVersion(releaseId);
        gavUSed = this.ksCtx.getKjarGAVUsed();
        Assert.assertTrue((boolean)gavUSed.isPresent());
        Assert.assertEquals((Object)"org.kie:sample-hacep-project-kjar:900.Final", gavUSed.get());
    }

    public void createAndDeployKJar(ReleaseId releaseId, Map<String, String> files) {
        KieFileSystem kfs = this.ks.newKieFileSystem().generateAndWritePomXML(releaseId);
        for (Map.Entry<String, String> file : files.entrySet()) {
            kfs.write(file.getKey(), file.getValue());
        }
        this.ks.newKieBuilder(kfs).buildAll();
        InternalKieModule kieModule = (InternalKieModule)this.ks.getRepository().getKieModule(releaseId);
        this.getRepository(this.ks).installArtifact((AFReleaseId)releaseId, kieModule.getBytes(), kfs.read("pom.xml"));
        this.ks.getRepository().removeKieModule(releaseId);
    }

    public MavenRepository getRepository(KieServices srv) {
        ReleaseId initReleaseId = GAVUtils.getReleaseID((String)"org.kie.server.initial:init-maven-repo:42", (KieServices)srv);
        KieFileSystem kfs = this.ks.newKieFileSystem().generateAndWritePomXML(initReleaseId);
        MavenProject minimalMavenProject = MavenProjectLoader.parseMavenPom((InputStream)new ByteArrayInputStream(kfs.read("pom.xml")));
        return KieMavenRepository.getKieMavenRepository((MavenProject)minimalMavenProject);
    }
}

