/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.logging;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.wildfly.swarm.bootstrap.logging.BackingLogger;
import org.wildfly.swarm.bootstrap.logging.BackingLoggerManager;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.logging.InitialBackingLogger;
import org.wildfly.swarm.bootstrap.logging.LevelNode;

public class InitialLoggerManager
implements BackingLoggerManager {
    public static final InitialLoggerManager INSTANCE = new InitialLoggerManager();
    private static final String LOGGER_ROOT = "ROOT";
    private static final String FORMAT = "%s %s [%s] (%s) %s";
    private static final String PREFIX = "thorntail.log.";
    private final LevelNode root;

    private InitialLoggerManager() {
        Properties props = System.getProperties();
        Set<String> names = props.stringPropertyNames();
        ArrayList<String> categories = new ArrayList<String>();
        HashMap<String, BootstrapLogger.Level> levels = new HashMap<String, BootstrapLogger.Level>();
        for (String name : names) {
            BootstrapLogger.Level level;
            if (!name.startsWith(PREFIX)) continue;
            String category = name.substring(PREFIX.length());
            String levelStr = props.getProperty(name);
            if (levelStr.equals("")) {
                level = BootstrapLogger.Level.INFO;
            } else {
                try {
                    level = Enum.valueOf(BootstrapLogger.Level.class, levelStr);
                }
                catch (IllegalArgumentException e) {
                    level = BootstrapLogger.Level.INFO;
                }
            }
            categories.add(category);
            levels.put(category, level);
        }
        categories.sort((l, r) -> l.compareTo((String)r));
        BootstrapLogger.Level rootLevel = (BootstrapLogger.Level)((Object)levels.get(LOGGER_ROOT));
        if (rootLevel == null) {
            rootLevel = BootstrapLogger.Level.NONE;
        }
        this.root = new LevelNode("", rootLevel);
        for (String each : categories) {
            if (each.equals(LOGGER_ROOT)) continue;
            this.root.add(each, (BootstrapLogger.Level)((Object)levels.get(each)));
        }
    }

    public LevelNode getRoot() {
        return this.root;
    }

    @Override
    public BackingLogger getBackingLogger(String name) {
        return new InitialBackingLogger(name, this.root.getLevel(name));
    }

    public synchronized void log(InitialBackingLogger logger, BootstrapLogger.Level level, Object message) {
        if (level.ordinal() < logger.getLevel().ordinal()) {
            return;
        }
        if (message instanceof Throwable) {
            this.log(logger, level, (Throwable)message);
        } else {
            this.log(logger, level, message.toString());
        }
    }

    public synchronized void log(InitialBackingLogger logger, BootstrapLogger.Level level, Object message, Throwable t) {
        if (level.ordinal() < logger.getLevel().ordinal()) {
            return;
        }
        this.log(logger, level, message);
        this.log(logger, level, t);
    }

    private void log(InitialBackingLogger logger, BootstrapLogger.Level level, String message) {
        String[] lines;
        Date now = new Date();
        for (String line : lines = message.split("\n")) {
            System.err.println(String.format(FORMAT, now, level.toString(), logger.getCategory(), Thread.currentThread().getName(), line));
        }
    }

    private void log(InitialBackingLogger logger, BootstrapLogger.Level level, Throwable t) {
        System.err.println(String.format(FORMAT, new Object[]{new Date().toString(), level, logger.getCategory(), Thread.currentThread().getName(), t.getMessage()}));
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            System.err.println("  " + stackTraceElement.toString());
        }
    }
}

