/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaders;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.bootstrap.util.BootstrapUtil;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.jdk.specific.JarFiles;

public class NestedJarResourceLoader {
    private static final String JAR_SUFFIX = ".jar!";
    private static Map<String, File> exploded = new HashMap<String, File>();
    private static Set<String> explosionNotRequired = new HashSet<String>();

    private NestedJarResourceLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean requiresExplosion(URL base) throws IOException {
        try (AutoCloseable locateHandle = Performance.accumulate("Is explosion needed?");){
            String urlString = base.toExternalForm();
            if (!urlString.startsWith("jar:file:")) return false;
            int endLoc = urlString.indexOf(JAR_SUFFIX);
            if (endLoc <= 0) return false;
            String jarPath = urlString.substring(9, endLoc + 4);
            File exp = exploded.get(jarPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()));
            if (exp != null) {
                boolean bl = true;
                return bl;
            }
            if (explosionNotRequired.contains(jarPath)) {
                boolean bl = false;
                return bl;
            }
            try (JarFile jarFile = JarFiles.create(jarPath);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry each = entries.nextElement();
                    if (each.isDirectory() || !each.getName().startsWith("modules") || each.getName().endsWith("/module.xml")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            explosionNotRequired.add(jarPath);
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized Path explodedJar(URL base) throws IOException {
        if (!NestedJarResourceLoader.requiresExplosion(base)) {
            return null;
        }
        try (AutoCloseable locateHandle = Performance.accumulate("Exploded JAR locating");){
            int endLoc;
            String urlString = base.toExternalForm();
            if (urlString.startsWith("jar:file:") && (endLoc = urlString.indexOf(JAR_SUFFIX)) > 0) {
                String remainder;
                Object object;
                String jarPath = urlString.substring(9, endLoc + 4);
                File exp = exploded.get(jarPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()));
                if (exp == null) {
                    AutoCloseable explodingHandle = Performance.accumulate("Exploding JAR");
                    object = null;
                    try {
                        exp = TempFileManager.INSTANCE.newTempDirectory("module-jar", ".jar_d");
                        try (JarFile jarFile = JarFiles.create(jarPath);){
                            Enumeration<JarEntry> entries = jarFile.entries();
                            while (entries.hasMoreElements()) {
                                JarEntry each = entries.nextElement();
                                if (each.isDirectory()) continue;
                                File out = new File(exp, each.getName());
                                out.getParentFile().mkdirs();
                                InputStream in = jarFile.getInputStream(each);
                                Files.copy(in, out.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                in.close();
                            }
                        }
                        exploded.put(jarPath, exp);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (explodingHandle != null) {
                            if (object != null) {
                                try {
                                    explodingHandle.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                explodingHandle.close();
                            }
                        }
                    }
                }
                if ((remainder = urlString.substring(endLoc + JAR_SUFFIX.length())).startsWith("/") || remainder.startsWith("\\")) {
                    remainder = remainder.substring(1);
                }
                object = exp.toPath().resolve(remainder);
                return object;
            }
            Path path = null;
            return path;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ResourceLoader loaderFor(URL base, String rootPath, String loaderPath, String loaderName) throws IOException {
        Path exp = NestedJarResourceLoader.explodedJar(base);
        String urlString = base.toExternalForm();
        if (exp != null) {
            int endLoc = urlString.indexOf(JAR_SUFFIX);
            if (endLoc > 0) {
                Path resourceRoot = exp.resolve(loaderPath);
                if (!Files.isDirectory(resourceRoot, new LinkOption[0]) && (resourceRoot.getFileName().toString().endsWith(".jar") || resourceRoot.getFileName().toString().endsWith(".war"))) {
                    File file = resourceRoot.toFile();
                    JarFile jarFile = JarFiles.create(file);
                    File tmpDir = TempFileManager.INSTANCE.newTempDirectory("nestedjarloader", null);
                    BootstrapUtil.explodeJar(jarFile, tmpDir.getAbsolutePath());
                    jarFile.close();
                    return ResourceLoaders.createFileResourceLoader(loaderName, tmpDir);
                }
                return ResourceLoaders.createFileResourceLoader(loaderName, resourceRoot.toFile());
            }
        } else {
            if (urlString.startsWith("file:")) {
                if (loaderName.endsWith(".jar") || loaderName.endsWith(".war")) {
                    File file = new File(urlString.substring(5), loaderPath);
                    JarFile jarFile = JarFiles.create(file);
                    File tmpDir = TempFileManager.INSTANCE.newTempDirectory("nestedjarloader", null);
                    BootstrapUtil.explodeJar(jarFile, tmpDir.getAbsolutePath());
                    jarFile.close();
                    return ResourceLoaders.createFileResourceLoader(loaderName, tmpDir);
                }
                return ResourceLoaders.createFileResourceLoader(loaderPath, new File(urlString.substring(5)));
            }
            return new AbstractResourceLoader(){};
        }
        throw new IllegalArgumentException("Illegal module loader base: " + base + " // " + loaderPath + " // " + loaderName);
    }
}

