/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class TempFileManager {
    public static final String TMPDIR_PROPERTY = "thorntail.io.tmpdir";
    public static final String WFSWARM_TMP_PREFIX = "thorntail";
    public static final TempFileManager INSTANCE = new TempFileManager();
    private static final Pattern tempFilePattern = Pattern.compile("thorntail\\S+[0-9]{5,}.\\S{5,}");
    private final Set<File> registered = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicReference<File> explodedApplicationArtifact = new AtomicReference();
    private File tmpDir;

    private TempFileManager() {
        String tmpDir = System.getProperty(TMPDIR_PROPERTY);
        if (tmpDir != null) {
            this.tmpDir = new File(tmpDir);
            if (!Files.exists(this.tmpDir.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectories(this.tmpDir.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static boolean isTempFile(File fp) {
        return tempFilePattern.matcher(fp.getName()).matches();
    }

    public File newTempDirectory(String base, String ext) throws IOException {
        File tmp = File.createTempFile(WFSWARM_TMP_PREFIX + base, ext, this.tmpDir);
        tmp.delete();
        tmp.mkdirs();
        this.register(tmp);
        return tmp;
    }

    public File newTempFile(String base, String ext) throws IOException {
        File tmp = File.createTempFile(WFSWARM_TMP_PREFIX + base, ext, this.tmpDir);
        tmp.delete();
        this.register(tmp);
        return tmp;
    }

    public File getExplodedApplicationArtifact() {
        return this.explodedApplicationArtifact.get();
    }

    public void setExplodedApplicationArtifact(File explodedApplicationArtifact) {
        this.explodedApplicationArtifact.set(explodedApplicationArtifact);
    }

    private void register(File file) {
        this.registered.add(file);
    }

    public synchronized void close() {
        this.registered.forEach(TempFileManager::deleteRecursively);
        this.registered.clear();
    }

    public static boolean deleteRecursively(File f) {
        if (!f.exists()) {
            return false;
        }
        try {
            Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

