/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.common.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.B64Code;
import org.junit.AfterClass;
import org.junit.Before;

public class ServerTestCase {
    protected static Server server;
    protected static Server proxy;
    protected static int proxyPort;
    protected static final AtomicInteger proxyHitCount;
    protected static final AtomicReference<String> proxyUser;
    protected static final AtomicReference<String> proxyPassword;

    public static String setUp(Handler handler) throws Exception {
        server = new Server();
        if (handler != null) {
            server.setHandler(handler);
        }
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        server.start();
        ServerTestCase.setupProxy();
        return "http://localhost:" + connector.getLocalPort();
    }

    public static void setupProxy() throws Exception {
        proxy = new Server();
        ServerConnector proxyConnector = new ServerConnector(proxy);
        proxyConnector.setPort(0);
        proxy.setConnectors(new Connector[]{proxyConnector});
        ServletHandler proxyHandler = new ServletHandler();
        RequestHandler proxyCountingHandler = new RequestHandler(){

            @Override
            public void handle(Request request, HttpServletResponse response) {
                proxyHitCount.incrementAndGet();
                String auth = request.getHeader("Proxy-Authorization");
                auth = auth.substring(auth.indexOf(32) + 1);
                auth = B64Code.decode((String)auth, (String)"UTF-8");
                int colon = auth.indexOf(58);
                proxyUser.set(auth.substring(0, colon));
                proxyPassword.set(auth.substring(colon + 1));
                request.setHandled(false);
            }
        };
        HandlerList handlerList = new HandlerList();
        handlerList.addHandler((Handler)proxyCountingHandler);
        handlerList.addHandler((Handler)proxyHandler);
        proxy.setHandler((Handler)handlerList);
        ServletHolder proxyHolder = proxyHandler.addServletWithMapping("org.eclipse.jetty.proxy.ProxyServlet", "/");
        proxyHolder.setAsyncSupported(true);
        proxy.start();
        proxyPort = proxyConnector.getLocalPort();
    }

    @Before
    public void clearProxyHitCount() {
        proxyHitCount.set(0);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (server != null) {
            server.stop();
        }
        if (proxy != null) {
            proxy.stop();
        }
    }

    static {
        proxyHitCount = new AtomicInteger(0);
        proxyUser = new AtomicReference();
        proxyPassword = new AtomicReference();
    }

    protected static abstract class RequestHandler
    extends AbstractHandler {
        private Request request;
        private HttpServletResponse response;

        protected RequestHandler() {
        }

        public abstract void handle(Request var1, HttpServletResponse var2);

        protected byte[] read() {
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            byte[] buffer = new byte[8196];
            try {
                int read;
                ServletInputStream input = this.request.getInputStream();
                while ((read = input.read(buffer)) != -1) {
                    content.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return content.toByteArray();
        }

        protected void write(String value) {
            try {
                this.response.getWriter().print(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void writeln(String value) {
            try {
                this.response.getWriter().println(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.request = (Request)request;
            this.response = response;
            this.request.setHandled(true);
            this.handle(this.request, response);
        }
    }
}

