/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.task.jaxb.ComparePair;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Assume;
import org.junit.Test;
import org.kie.api.definition.KieDefinition;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.services.client.serialization.jaxb.impl.JaxbRequestStatus;
import org.kie.services.client.serialization.jaxb.impl.JaxbVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbNodeInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbVariableInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentDescriptor;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceListResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItemResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteSerializationTest
extends JbpmJUnitBaseTestCase {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRemoteSerializationTest.class);
    private static Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)"org.kie.services.client", (ClassLoader[])new ClassLoader[0]), ClasspathHelper.forPackage((String)"org.kie.remote", (ClassLoader[])new ClassLoader[0]), new TypeAnnotationsScanner(), new FieldAnnotationsScanner(), new MethodAnnotationsScanner(), new SubTypesScanner()});

    public abstract TestType getType();

    public abstract void addClassesToSerializationProvider(Class<?> ... var1);

    public abstract <T> T testRoundTrip(T var1) throws Exception;

    @Test
    public void jaxbClassesTest() throws Exception {
        Assume.assumeFalse((boolean)TestType.YAML.equals((Object)this.getType()));
        int i = 0;
        for (Class jaxbClass : reflections.getTypesAnnotatedWith(XmlRootElement.class)) {
            ++i;
            Constructor construct = jaxbClass.getConstructor(new Class[0]);
            Object jaxbInst = construct.newInstance(new Object[0]);
            this.testRoundTrip(jaxbInst);
        }
        AbstractRemoteSerializationTest.assertTrue((i > 20 ? 1 : 0) != 0);
    }

    @Test
    public void genericResponseTest() throws Exception {
        JaxbGenericResponse resp = new JaxbGenericResponse();
        resp.setMessage("error");
        resp.setStatus(JaxbRequestStatus.SUCCESS);
        resp.setUrl("http://here");
        this.testRoundTrip(resp);
    }

    @Test
    public void exceptionTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbExceptionResponse resp = new JaxbExceptionResponse();
        resp.setMessage("error");
        resp.setStatus(JaxbRequestStatus.SUCCESS);
        resp.setUrl("http://here");
        RuntimeException re = new RuntimeException();
        resp.setCause((Exception)re);
        this.testRoundTrip(resp);
    }

    @Test
    public void variablesResponseTest() throws Exception {
        JaxbVariablesResponse resp = new JaxbVariablesResponse();
        this.testRoundTrip(resp);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("one", "two");
        resp.setVariables(vars);
        this.testRoundTrip(resp);
    }

    @Test
    public void historyLogListTest() throws Exception {
        JaxbHistoryLogList resp = new JaxbHistoryLogList();
        this.testRoundTrip(resp);
        org.jbpm.process.audit.VariableInstanceLog vLog = new org.jbpm.process.audit.VariableInstanceLog(23L, "process", "varInst", "var", "two", "one");
        vLog.setExternalId("domain");
        Field dateField = org.jbpm.process.audit.VariableInstanceLog.class.getDeclaredField("date");
        dateField.setAccessible(true);
        dateField.set(vLog, new Date());
        Field idField = org.jbpm.process.audit.VariableInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(vLog, 32L);
        resp.getHistoryLogList().add(new JaxbVariableInstanceLog((VariableInstanceLog)vLog));
        org.jbpm.process.audit.ProcessInstanceLog pLog = new org.jbpm.process.audit.ProcessInstanceLog(23L, "process");
        pLog.setDuration(Long.valueOf(2000L));
        pLog.setEnd(new Date());
        pLog.setExternalId("domain");
        pLog.setIdentity("id");
        pLog.setOutcome("error");
        pLog.setParentProcessInstanceId(42L);
        pLog.setProcessName("name");
        pLog.setProcessVersion("1-SNAP");
        pLog.setStatus(2);
        idField = org.jbpm.process.audit.ProcessInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(pLog, 32L);
        resp.getHistoryLogList().add(new JaxbProcessInstanceLog((ProcessInstanceLog)pLog));
        org.jbpm.process.audit.NodeInstanceLog nLog = new org.jbpm.process.audit.NodeInstanceLog(0, 23L, "process", "nodeInst", "node", "wally");
        idField = org.jbpm.process.audit.NodeInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(nLog, 32L);
        dateField = org.jbpm.process.audit.NodeInstanceLog.class.getDeclaredField("date");
        dateField.setAccessible(true);
        dateField.set(nLog, new Date());
        nLog.setNodeType("type");
        nLog.setWorkItemId(Long.valueOf(88L));
        nLog.setConnection("connex");
        nLog.setExternalId("domain");
        resp.getHistoryLogList().add(new JaxbNodeInstanceLog((NodeInstanceLog)nLog));
        this.testRoundTrip(resp);
    }

    @Test
    public void processInstanceWithVariablesTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.JAXB));
        this.setupDataSource = true;
        this.sessionPersistence = true;
        super.setUp();
        RuntimeEngine runtimeEngine = this.createRuntimeManager(new String[]{"BPMN2-StringStructureRef.bpmn2"}).getRuntimeEngine(null);
        KieSession ksession = runtimeEngine.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        String val = "initial-val";
        params.put("test", val);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        AbstractRemoteSerializationTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "initial-val");
        JaxbProcessInstanceWithVariablesResponse jpiwvr = new JaxbProcessInstanceWithVariablesResponse(processInstance, map);
        this.testRoundTrip(jpiwvr);
        JaxbProcessInstanceListResponse jpilp = new JaxbProcessInstanceListResponse();
        ArrayList<JaxbProcessInstanceResponse> procInstList = new ArrayList<JaxbProcessInstanceResponse>();
        procInstList.add(new JaxbProcessInstanceResponse(processInstance));
        jpilp.setResult(procInstList);
        this.testRoundTrip(jpilp);
        super.tearDown();
        this.setupDataSource = false;
        this.sessionPersistence = false;
    }

    @Test
    public void workItemObjectTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbWorkItemResponse workitemObject = new JaxbWorkItemResponse();
        workitemObject.setId(Long.valueOf(35L));
        workitemObject.setName("Clau");
        workitemObject.setState(Integer.valueOf(0));
        workitemObject.setProcessInstanceId(Long.valueOf(1L));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "driving");
        workitemObject.setParameters(params);
        JaxbWorkItemResponse roundTripWorkItem = this.testRoundTrip(workitemObject);
        ComparePair.compareObjectsViaFields((Object)workitemObject, (Object)roundTripWorkItem);
    }

    @Test
    public void nodeInstanceLogNpeTest() throws Exception {
        org.jbpm.process.audit.NodeInstanceLog nodeLog = new org.jbpm.process.audit.NodeInstanceLog();
        JaxbNodeInstanceLog jaxbNodeLog = new JaxbNodeInstanceLog((NodeInstanceLog)nodeLog);
        this.testRoundTrip(jaxbNodeLog);
    }

    @Test
    public void deploymentObjectsTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbDeploymentUnitList depUnitList = new JaxbDeploymentUnitList();
        JaxbDeploymentJobResult jaxbJob = new JaxbDeploymentJobResult();
        this.testRoundTrip(jaxbJob);
        KModuleDeploymentUnit kDepUnit = new KModuleDeploymentUnit("org", "jar", "1.0", "kbase", "ksession");
        kDepUnit.setStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        JaxbDeploymentUnit depUnit = new JaxbDeploymentUnit(kDepUnit.getGroupId(), kDepUnit.getArtifactId(), kDepUnit.getArtifactId());
        depUnit.setKbaseName(kDepUnit.getKbaseName());
        depUnit.setKsessionName(kDepUnit.getKsessionName());
        depUnit.setStrategy(kDepUnit.getStrategy());
        depUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.NONEXISTENT);
        depUnitList.getDeploymentUnitList().add(depUnit);
        jaxbJob = new JaxbDeploymentJobResult(null, "test", depUnit, "deploy");
        jaxbJob.setIdentifier(Long.valueOf(23L));
        jaxbJob.setSuccess(Boolean.valueOf(false));
        JaxbDeploymentJobResult copyJaxbJob = this.testRoundTrip(jaxbJob);
        ComparePair.compareObjectsViaFields((Object)jaxbJob, (Object)copyJaxbJob, (String[])new String[]{"jobId", "identifier"});
        depUnit = new JaxbDeploymentUnit("g", "a", "v");
        depUnit.setKbaseName("kbase");
        depUnit.setKsessionName("ksession");
        depUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED);
        depUnit.setStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        depUnitList.getDeploymentUnitList().add(depUnit);
        JaxbDeploymentUnit copyDepUnit = this.testRoundTrip(depUnit);
        ComparePair.compareObjectsViaFields((Object)depUnit, (Object)copyDepUnit, (String[])new String[]{"identifier"});
        JaxbDeploymentJobResult depJob = new JaxbDeploymentJobResult(null, "testing stuff", copyDepUnit, "test");
        depJob.setSuccess(Boolean.valueOf(true));
        JaxbDeploymentJobResult copyDepJob = this.testRoundTrip(depJob);
        ComparePair.compareObjectsViaFields((Object)copyDepJob, (Object)depJob, (String[])new String[]{"jobId", "identifier"});
        JaxbDeploymentUnitList roundTripUnitList = this.testRoundTrip(depUnitList);
        ComparePair.compareObjectsViaFields(depUnitList.getDeploymentUnitList().get(0), roundTripUnitList.getDeploymentUnitList().get(0), (String[])new String[]{"jobId", "identifier"});
    }

    @Test
    public void processInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        org.jbpm.process.audit.ProcessInstanceLog origLog = new org.jbpm.process.audit.ProcessInstanceLog(54L, "org.hospital.patient.triage");
        origLog.setDuration(Long.valueOf(65L));
        origLog.setDuration(Long.valueOf(234L));
        origLog.setEnd(new Date(new Date().getTime() + 1000L));
        origLog.setExternalId("testDomainId");
        origLog.setIdentity("identityNotMemory");
        origLog.setStatus(2);
        origLog.setOutcome("descriptiveErrorCodeOfAnError");
        origLog.setParentProcessInstanceId(65L);
        origLog.setProcessName("org.process.not.technical");
        origLog.setProcessVersion("v3.14");
        JaxbProcessInstanceLog xmlLog = new JaxbProcessInstanceLog((ProcessInstanceLog)origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        JaxbProcessInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareObjectsViaFields((Object)xmlLog, (Object)newXmlLog, (String[])new String[]{"id"});
        ProcessInstanceLog newLog = newXmlLog.getResult();
        org.jbpm.process.audit.ProcessInstanceLog origCmpLog = origLog;
        AbstractRemoteSerializationTest.assertEquals((Object)origLog.getExternalId(), (Object)newLog.getExternalId());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getIdentity(), (Object)newLog.getIdentity());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getOutcome(), (Object)newLog.getOutcome());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getProcessId(), (Object)newLog.getProcessId());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getProcessName(), (Object)newLog.getProcessName());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getProcessVersion(), (Object)newLog.getProcessVersion());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getDuration(), (Object)newLog.getDuration());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getEnd(), (Object)newLog.getEnd());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getParentProcessInstanceId(), (Object)newLog.getParentProcessInstanceId());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getProcessInstanceId(), (Object)newLog.getProcessInstanceId());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getStart(), (Object)newLog.getStart());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getStatus(), (Object)newLog.getStatus());
    }

    @Test
    public void processInstanceLogNillable() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        org.jbpm.process.audit.ProcessInstanceLog origLog = new org.jbpm.process.audit.ProcessInstanceLog(54L, "org.hospital.patient.triage");
        origLog.setDuration(Long.valueOf(65L));
        origLog.setEnd(new Date(new Date().getTime() + 1000L));
        origLog.setExternalId("testDomainId");
        origLog.setIdentity("identityNotMemory");
        origLog.setProcessName("org.process.not.technical");
        origLog.setProcessVersion("v3.14");
        JaxbProcessInstanceLog xmlLog = new JaxbProcessInstanceLog((ProcessInstanceLog)origLog);
        JaxbProcessInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getProcessInstanceId(), (Object)newXmlLog.getProcessInstanceId());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getProcessId(), (Object)newXmlLog.getProcessId());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getDuration(), (Object)newXmlLog.getDuration());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getEnd(), (Object)newXmlLog.getEnd());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getExternalId(), (Object)newXmlLog.getExternalId());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getIdentity(), (Object)newXmlLog.getIdentity());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getStatus(), (Object)newXmlLog.getStatus());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getOutcome(), (Object)newXmlLog.getOutcome());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getParentProcessInstanceId(), (Object)newXmlLog.getParentProcessInstanceId());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getProcessName(), (Object)newXmlLog.getProcessName());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getProcessVersion(), (Object)newXmlLog.getProcessVersion());
    }

    @Test
    public void nodeInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        int type = 0;
        long processInstanceId = 23L;
        String processId = "org.hospital.doctor.review";
        String nodeInstanceId = "1-1";
        String nodeId = "1";
        String nodeName = "notification";
        org.jbpm.process.audit.NodeInstanceLog origLog = new org.jbpm.process.audit.NodeInstanceLog(type, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        origLog.setWorkItemId(Long.valueOf(78L));
        origLog.setConnection("link");
        origLog.setExternalId("not-internal-num");
        origLog.setNodeType("the-sort-of-point");
        JaxbNodeInstanceLog xmlLog = new JaxbNodeInstanceLog((NodeInstanceLog)origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        xmlLog.setId(Long.valueOf(2L));
        JaxbNodeInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareOrig((Object)xmlLog, (Object)newXmlLog, JaxbNodeInstanceLog.class);
        NodeInstanceLog newLog = newXmlLog.getResult();
        ComparePair.compareOrig((Object)origLog, (Object)newLog, NodeInstanceLog.class);
    }

    @Test
    public void variableInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        long processInstanceId = 23L;
        String processId = "org.hospital.intern.rounds";
        String variableInstanceId = "patientNum-1";
        String variableId = "patientNum";
        String value = "33";
        String oldValue = "32";
        org.jbpm.process.audit.VariableInstanceLog origLog = new org.jbpm.process.audit.VariableInstanceLog(processInstanceId, processId, variableInstanceId, variableId, value, oldValue);
        origLog.setExternalId("outside-identity-representation");
        origLog.setOldValue("previous-data-that-this-variable-contains");
        origLog.setValue("the-new-data-that-has-been-put-in-this-variable");
        origLog.setVariableId("shortend-representation-of-this-representation");
        origLog.setVariableInstanceId("id-instance-variable");
        JaxbVariableInstanceLog xmlLog = new JaxbVariableInstanceLog((VariableInstanceLog)origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        JaxbVariableInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareObjectsViaFields((Object)xmlLog, (Object)newXmlLog, (String[])new String[]{"id"});
        VariableInstanceLog newLog = newXmlLog.getResult();
        ComparePair.compareOrig((Object)origLog, (Object)newLog, VariableInstanceLog.class);
    }

    @Test
    public void processIdAndProcessDefinitionTest() throws Exception {
        ProcessAssetDesc assetDesc = new ProcessAssetDesc("org.test.proc.id", "The Name Of The Process", "1.999.23.Final", "org.test.proc", "RuleFlow", KieDefinition.KnowledgeType.PROCESS.toString(), "org.test.proc", "org.test.proc:procs:1.999.Final");
        JaxbProcessDefinition jaxbProcDef = new JaxbProcessDefinition();
        jaxbProcDef.setDeploymentId(assetDesc.getDeploymentId());
        jaxbProcDef.setId(assetDesc.getId());
        jaxbProcDef.setName(assetDesc.getName());
        jaxbProcDef.setPackageName(assetDesc.getPackageName());
        jaxbProcDef.setVersion(assetDesc.getVersion());
        HashMap<String, String> forms = new HashMap<String, String>();
        forms.put("locationForm", "GPS: street: post code: city: state: land: planet: universe: ");
        jaxbProcDef.setForms(forms);
        JaxbProcessDefinition copyJaxbProcDef = this.testRoundTrip(jaxbProcDef);
        ComparePair.compareObjectsViaFields((Object)jaxbProcDef, (Object)copyJaxbProcDef);
    }

    @Test
    public void deploymentDescriptorTest() throws Exception {
        JaxbDeploymentDescriptor depDescriptor = new JaxbDeploymentDescriptor();
        depDescriptor.setAuditMode(AuditMode.JMS);
        depDescriptor.setAuditPersistenceUnit("myDatabasePersistenceUnit");
        String[] classes = new String[]{"org.test.First", "org.more.test.Second"};
        depDescriptor.setClasses(Arrays.asList(classes));
        depDescriptor.setConfiguration(this.getNamedObjectModeList("conf"));
        depDescriptor.setEnvironmentEntries(this.getNamedObjectModeList("envEnt"));
    }

    private List<NamedObjectModel> getNamedObjectModeList(String type) {
        type = "-" + type;
        ArrayList<NamedObjectModel> namedObjectModelList = new ArrayList<NamedObjectModel>();
        for (int i = 0; i < 2; ++i) {
            NamedObjectModel nom = new NamedObjectModel();
            nom.setIdentifier("id-" + i + type);
            nom.setName("name-" + i + type);
            String[] params = new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString()};
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.addAll(Arrays.asList(params));
            nom.setParameters(paramList);
            nom.setResolver(i + "-resolver" + type);
            namedObjectModelList.add(nom);
        }
        return namedObjectModelList;
    }

    protected static enum TestType {
        JAXB,
        JSON,
        YAML;

    }
}

