/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.AbstractRemoteSerializationTest;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceListResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessInstancesRemoteSerializationTest
extends JbpmJUnitBaseTestCase {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRemoteSerializationTest.class);

    public abstract AbstractRemoteSerializationTest.TestType getType();

    public abstract void addClassesToSerializationProvider(Class<?> ... var1);

    public abstract <T> T testRoundTrip(T var1) throws Exception;

    public AbstractProcessInstancesRemoteSerializationTest() {
        super(true, true);
    }

    @Test
    public void processInstanceWithVariablesTest() throws Exception {
        RuntimeEngine runtimeEngine = this.createRuntimeManager(new String[]{"BPMN2-StringStructureRef.bpmn2"}).getRuntimeEngine(null);
        KieSession ksession = runtimeEngine.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        String val = "initial-val";
        params.put("test", val);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        AbstractProcessInstancesRemoteSerializationTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "initial-val");
        JaxbProcessInstanceWithVariablesResponse jpiwvr = new JaxbProcessInstanceWithVariablesResponse(processInstance, map);
        this.testRoundTrip(jpiwvr);
        JaxbProcessInstanceListResponse jpilp = new JaxbProcessInstanceListResponse();
        ArrayList<JaxbProcessInstanceResponse> procInstList = new ArrayList<JaxbProcessInstanceResponse>();
        procInstList.add(new JaxbProcessInstanceResponse(processInstance));
        jpilp.setResult(procInstList);
        this.testRoundTrip(jpilp);
    }
}

