/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Assume;
import org.junit.Test;
import org.kie.api.definition.KieDefinition;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.process.CorrelationProperty;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.services.client.serialization.jaxb.impl.JaxbRequestStatus;
import org.kie.services.client.serialization.jaxb.impl.JaxbVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbNodeInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbVariableInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentDescriptor;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceListResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItemResponse;
import org.kie.services.client.serialization.jaxb.impl.runtime.JaxbCorrelationKey;
import org.kie.services.client.serialization.jaxb.impl.runtime.JaxbCorrelationProperty;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbArray;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbBoolean;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbByte;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbCharacter;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbDouble;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbFloat;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbInteger;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbList;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbLong;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbMap;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbSet;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbShort;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbString;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbType;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.test.util.compare.ComparePair;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteSerializationTest
extends JbpmJUnitBaseTestCase {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRemoteSerializationTest.class);
    private static Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)"org.kie.services.client", (ClassLoader[])new ClassLoader[0]), ClasspathHelper.forPackage((String)"org.kie.remote", (ClassLoader[])new ClassLoader[0]), new TypeAnnotationsScanner(), new SubTypesScanner()});

    public abstract TestType getType();

    public abstract void addClassesToSerializationProvider(Class<?> ... var1);

    public abstract <T> T testRoundTrip(T var1) throws Exception;

    @Test
    public void jaxbClassesTest() throws Exception {
        Assume.assumeTrue((boolean)TestType.JAXB.equals((Object)this.getType()));
        Set jaxbClasses = reflections.getTypesAnnotatedWith(XmlRootElement.class);
        AbstractRemoteSerializationTest.assertTrue((String)("Not enough classes found! [" + jaxbClasses.size() + "]"), (jaxbClasses.size() > 20 ? 1 : 0) != 0);
        String className = null;
        try {
            for (Class jaxbClass : jaxbClasses) {
                if (jaxbClass.getDeclaringClass() != null && jaxbClass.getDeclaringClass().getSimpleName().endsWith("Test")) continue;
                className = jaxbClass.getName();
                Constructor construct = jaxbClass.getConstructor(new Class[0]);
                Object jaxbInst = construct.newInstance(new Object[0]);
                this.testRoundTrip(jaxbInst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractRemoteSerializationTest.fail((String)(className + ": " + e.getClass().getSimpleName() + " [" + e.getMessage() + "]"));
        }
    }

    @Test
    public void genericResponseTest() throws Exception {
        JaxbGenericResponse resp = new JaxbGenericResponse();
        resp.setMessage("error");
        resp.setStatus(JaxbRequestStatus.SUCCESS);
        resp.setUrl("http://here");
        this.testRoundTrip(resp);
    }

    @Test
    public void exceptionTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbExceptionResponse resp = new JaxbExceptionResponse();
        resp.setMessage("error");
        resp.setStatus(JaxbRequestStatus.SUCCESS);
        resp.setUrl("http://here");
        RuntimeException re = new RuntimeException();
        resp.setCause((Exception)re);
        this.testRoundTrip(resp);
    }

    @Test
    public void variablesResponseTest() throws Exception {
        JaxbVariablesResponse resp = new JaxbVariablesResponse();
        this.testRoundTrip(resp);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("one", "two");
        resp.setVariables(vars);
        this.testRoundTrip(resp);
    }

    @Test
    public void historyLogListTest() throws Exception {
        JaxbHistoryLogList resp = new JaxbHistoryLogList();
        this.testRoundTrip(resp);
        org.jbpm.process.audit.VariableInstanceLog vLog = new org.jbpm.process.audit.VariableInstanceLog(23L, "process", "varInst", "var", "two", "one");
        vLog.setExternalId("domain");
        Field dateField = org.jbpm.process.audit.VariableInstanceLog.class.getDeclaredField("date");
        dateField.setAccessible(true);
        dateField.set(vLog, new Date());
        Field idField = org.jbpm.process.audit.VariableInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(vLog, 32L);
        resp.getHistoryLogList().add(new JaxbVariableInstanceLog((VariableInstanceLog)vLog));
        org.jbpm.process.audit.ProcessInstanceLog pLog = new org.jbpm.process.audit.ProcessInstanceLog(23L, "process");
        pLog.setDuration(Long.valueOf(2000L));
        pLog.setEnd(new Date());
        pLog.setExternalId("domain");
        pLog.setIdentity("id");
        pLog.setOutcome("error");
        pLog.setParentProcessInstanceId(42L);
        pLog.setProcessName("name");
        pLog.setProcessVersion("1-SNAP");
        pLog.setStatus(2);
        idField = org.jbpm.process.audit.ProcessInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(pLog, 32L);
        resp.getHistoryLogList().add(new JaxbProcessInstanceLog((ProcessInstanceLog)pLog));
        org.jbpm.process.audit.NodeInstanceLog nLog = new org.jbpm.process.audit.NodeInstanceLog(0, 23L, "process", "nodeInst", "node", "wally");
        idField = org.jbpm.process.audit.NodeInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(nLog, 32L);
        dateField = org.jbpm.process.audit.NodeInstanceLog.class.getDeclaredField("date");
        dateField.setAccessible(true);
        dateField.set(nLog, new Date());
        nLog.setNodeType("type");
        nLog.setWorkItemId(Long.valueOf(88L));
        nLog.setConnection("connex");
        nLog.setExternalId("domain");
        resp.getHistoryLogList().add(new JaxbNodeInstanceLog((NodeInstanceLog)nLog));
        this.testRoundTrip(resp);
    }

    @Test
    public void processInstanceWithVariablesTest() throws Exception {
        this.setupDataSource = true;
        this.sessionPersistence = true;
        super.setUp();
        RuntimeEngine runtimeEngine = this.createRuntimeManager(new String[]{"BPMN2-StringStructureRef.bpmn2"}).getRuntimeEngine(null);
        KieSession ksession = runtimeEngine.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        String val = "initial-val";
        params.put("test", val);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        AbstractRemoteSerializationTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "initial-val");
        JaxbProcessInstanceWithVariablesResponse jpiwvr = new JaxbProcessInstanceWithVariablesResponse(processInstance, map);
        this.testRoundTrip(jpiwvr);
        JaxbProcessInstanceListResponse jpilp = new JaxbProcessInstanceListResponse();
        ArrayList<JaxbProcessInstanceResponse> procInstList = new ArrayList<JaxbProcessInstanceResponse>();
        procInstList.add(new JaxbProcessInstanceResponse(processInstance));
        jpilp.setResult(procInstList);
        this.testRoundTrip(jpilp);
        super.tearDown();
        this.setupDataSource = false;
        this.sessionPersistence = false;
    }

    @Test
    public void workItemObjectTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbWorkItemResponse workitemObject = new JaxbWorkItemResponse();
        workitemObject.setId(Long.valueOf(35L));
        workitemObject.setName("Clau");
        workitemObject.setState(Integer.valueOf(0));
        workitemObject.setProcessInstanceId(Long.valueOf(1L));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "driving");
        workitemObject.setParameters(params);
        JaxbWorkItemResponse roundTripWorkItem = this.testRoundTrip(workitemObject);
        ComparePair.compareObjectsViaFields((Object)workitemObject, (Object)roundTripWorkItem);
    }

    @Test
    public void nodeInstanceLogNpeTest() throws Exception {
        org.jbpm.process.audit.NodeInstanceLog nodeLog = new org.jbpm.process.audit.NodeInstanceLog();
        JaxbNodeInstanceLog jaxbNodeLog = new JaxbNodeInstanceLog((NodeInstanceLog)nodeLog);
        this.testRoundTrip(jaxbNodeLog);
    }

    @Test
    public void deploymentObjectsTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbDeploymentUnitList depUnitList = new JaxbDeploymentUnitList();
        JaxbDeploymentJobResult jaxbJob = new JaxbDeploymentJobResult();
        this.testRoundTrip(jaxbJob);
        KModuleDeploymentUnit kDepUnit = new KModuleDeploymentUnit("org", "jar", "1.0", "kbase", "ksession");
        kDepUnit.setStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        JaxbDeploymentUnit depUnit = new JaxbDeploymentUnit(kDepUnit.getGroupId(), kDepUnit.getArtifactId(), kDepUnit.getArtifactId());
        depUnit.setKbaseName(kDepUnit.getKbaseName());
        depUnit.setKsessionName(kDepUnit.getKsessionName());
        depUnit.setStrategy(kDepUnit.getStrategy());
        depUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.NONEXISTENT);
        depUnitList.getDeploymentUnitList().add(depUnit);
        jaxbJob = new JaxbDeploymentJobResult(null, "test", depUnit, "deploy");
        jaxbJob.setIdentifier(Long.valueOf(23L));
        jaxbJob.setSuccess(Boolean.valueOf(false));
        JaxbDeploymentJobResult copyJaxbJob = this.testRoundTrip(jaxbJob);
        ComparePair.compareObjectsViaFields((Object)jaxbJob, (Object)copyJaxbJob, (String[])new String[]{"jobId", "identifier"});
        depUnit = new JaxbDeploymentUnit("g", "a", "v");
        depUnit.setKbaseName("kbase");
        depUnit.setKsessionName("ksession");
        depUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED);
        depUnit.setStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        depUnitList.getDeploymentUnitList().add(depUnit);
        JaxbDeploymentUnit copyDepUnit = this.testRoundTrip(depUnit);
        ComparePair.compareObjectsViaFields((Object)depUnit, (Object)copyDepUnit, (String[])new String[]{"identifier"});
        JaxbDeploymentJobResult depJob = new JaxbDeploymentJobResult(null, "testing stuff", copyDepUnit, "test");
        depJob.setSuccess(Boolean.valueOf(true));
        JaxbDeploymentJobResult copyDepJob = this.testRoundTrip(depJob);
        ComparePair.compareObjectsViaFields((Object)copyDepJob, (Object)depJob, (String[])new String[]{"jobId", "identifier"});
        JaxbDeploymentUnitList roundTripUnitList = this.testRoundTrip(depUnitList);
        ComparePair.compareObjectsViaFields(depUnitList.getDeploymentUnitList().get(0), roundTripUnitList.getDeploymentUnitList().get(0), (String[])new String[]{"jobId", "identifier"});
    }

    @Test
    public void processInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        org.jbpm.process.audit.ProcessInstanceLog origLog = new org.jbpm.process.audit.ProcessInstanceLog(54L, "org.hospital.patient.triage");
        origLog.setDuration(Long.valueOf(65L));
        origLog.setDuration(Long.valueOf(234L));
        origLog.setEnd(new Date(new Date().getTime() + 1000L));
        origLog.setExternalId("testDomainId");
        origLog.setIdentity("identityNotMemory");
        origLog.setProcessInstanceDescription("What a process, say!");
        origLog.setStatus(2);
        origLog.setOutcome("descriptiveErrorCodeOfAnError");
        origLog.setParentProcessInstanceId(65L);
        origLog.setProcessName("org.process.not.technical");
        origLog.setProcessVersion("v3.14");
        JaxbProcessInstanceLog xmlLog = new JaxbProcessInstanceLog((ProcessInstanceLog)origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        JaxbProcessInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareObjectsViaFields((Object)xmlLog, (Object)newXmlLog, (String[])new String[]{"id"});
        ProcessInstanceLog newLog = newXmlLog.getResult();
        org.jbpm.process.audit.ProcessInstanceLog origCmpLog = origLog;
        AbstractRemoteSerializationTest.assertEquals((Object)origLog.getExternalId(), (Object)newLog.getExternalId());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getIdentity(), (Object)newLog.getIdentity());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getOutcome(), (Object)newLog.getOutcome());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getProcessId(), (Object)newLog.getProcessId());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getProcessName(), (Object)newLog.getProcessName());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getProcessVersion(), (Object)newLog.getProcessVersion());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getDuration(), (Object)newLog.getDuration());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getEnd(), (Object)newLog.getEnd());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getParentProcessInstanceId(), (Object)newLog.getParentProcessInstanceId());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getProcessInstanceId(), (Object)newLog.getProcessInstanceId());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getStart(), (Object)newLog.getStart());
        AbstractRemoteSerializationTest.assertEquals((Object)origCmpLog.getStatus(), (Object)newLog.getStatus());
    }

    @Test
    public void processInstanceLogNillable() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        org.jbpm.process.audit.ProcessInstanceLog origLog = new org.jbpm.process.audit.ProcessInstanceLog(54L, "org.hospital.patient.triage");
        origLog.setDuration(Long.valueOf(65L));
        origLog.setEnd(new Date(new Date().getTime() + 1000L));
        origLog.setExternalId("testDomainId");
        origLog.setIdentity("identityNotMemory");
        origLog.setProcessName("org.process.not.technical");
        origLog.setProcessVersion("v3.14");
        JaxbProcessInstanceLog xmlLog = new JaxbProcessInstanceLog((ProcessInstanceLog)origLog);
        JaxbProcessInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getProcessInstanceId(), (Object)newXmlLog.getProcessInstanceId());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getProcessId(), (Object)newXmlLog.getProcessId());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getDuration(), (Object)newXmlLog.getDuration());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getEnd(), (Object)newXmlLog.getEnd());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getExternalId(), (Object)newXmlLog.getExternalId());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getIdentity(), (Object)newXmlLog.getIdentity());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getStatus(), (Object)newXmlLog.getStatus());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getOutcome(), (Object)newXmlLog.getOutcome());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getParentProcessInstanceId(), (Object)newXmlLog.getParentProcessInstanceId());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getProcessName(), (Object)newXmlLog.getProcessName());
        AbstractRemoteSerializationTest.assertEquals((Object)xmlLog.getProcessVersion(), (Object)newXmlLog.getProcessVersion());
    }

    @Test
    public void nodeInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        int type = 0;
        long processInstanceId = 23L;
        String processId = "org.hospital.doctor.review";
        String nodeInstanceId = "1-1";
        String nodeId = "1";
        String nodeName = "notification";
        org.jbpm.process.audit.NodeInstanceLog origLog = new org.jbpm.process.audit.NodeInstanceLog(type, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        origLog.setWorkItemId(Long.valueOf(78L));
        origLog.setConnection("link");
        origLog.setExternalId("not-internal-num");
        origLog.setNodeType("the-sort-of-point");
        JaxbNodeInstanceLog xmlLog = new JaxbNodeInstanceLog((NodeInstanceLog)origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        xmlLog.setId(Long.valueOf(2L));
        JaxbNodeInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareOrig((Object)xmlLog, (Object)newXmlLog, JaxbNodeInstanceLog.class);
        NodeInstanceLog newLog = newXmlLog.getResult();
        ComparePair.compareOrig((Object)origLog, (Object)newLog, NodeInstanceLog.class);
    }

    @Test
    public void variableInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        long processInstanceId = 23L;
        String processId = "org.hospital.intern.rounds";
        String variableInstanceId = "patientNum-1";
        String variableId = "patientNum";
        String value = "33";
        String oldValue = "32";
        org.jbpm.process.audit.VariableInstanceLog origLog = new org.jbpm.process.audit.VariableInstanceLog(processInstanceId, processId, variableInstanceId, variableId, value, oldValue);
        origLog.setExternalId("outside-identity-representation");
        origLog.setOldValue("previous-data-that-this-variable-contains");
        origLog.setValue("the-new-data-that-has-been-put-in-this-variable");
        origLog.setVariableId("shortend-representation-of-this-representation");
        origLog.setVariableInstanceId("id-instance-variable");
        JaxbVariableInstanceLog xmlLog = new JaxbVariableInstanceLog((VariableInstanceLog)origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        JaxbVariableInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareObjectsViaFields((Object)xmlLog, (Object)newXmlLog, (String[])new String[]{"id"});
        VariableInstanceLog newLog = newXmlLog.getResult();
        ComparePair.compareOrig((Object)origLog, (Object)newLog, VariableInstanceLog.class);
    }

    @Test
    public void processIdAndProcessDefinitionTest() throws Exception {
        ProcessAssetDesc assetDesc = new ProcessAssetDesc("org.test.proc.id", "The Name Of The Process", "1.999.23.Final", "org.test.proc", "RuleFlow", KieDefinition.KnowledgeType.PROCESS.toString(), "org.test.proc", "org.test.proc:procs:1.999.Final");
        JaxbProcessDefinition jaxbProcDef = new JaxbProcessDefinition();
        jaxbProcDef.setDeploymentId(assetDesc.getDeploymentId());
        jaxbProcDef.setId(assetDesc.getId());
        jaxbProcDef.setName(assetDesc.getName());
        jaxbProcDef.setPackageName(assetDesc.getPackageName());
        jaxbProcDef.setVersion(assetDesc.getVersion());
        HashMap<String, String> forms = new HashMap<String, String>();
        forms.put("locationForm", "GPS: street: post code: city: state: land: planet: universe: ");
        jaxbProcDef.setForms(forms);
        JaxbProcessDefinition copyJaxbProcDef = this.testRoundTrip(jaxbProcDef);
        ComparePair.compareObjectsViaFields((Object)jaxbProcDef, (Object)copyJaxbProcDef);
    }

    @Test
    public void deploymentDescriptorTest() throws Exception {
        JaxbDeploymentDescriptor depDescriptor = new JaxbDeploymentDescriptor();
        depDescriptor.setAuditMode(AuditMode.JMS);
        depDescriptor.setAuditPersistenceUnit("myDatabasePersistenceUnit");
        String[] classes = new String[]{"org.test.First", "org.more.test.Second"};
        depDescriptor.setRemoteableClasses(Arrays.asList(classes));
        depDescriptor.setConfiguration(this.getNamedObjectModeList("conf"));
        depDescriptor.setEnvironmentEntries(this.getNamedObjectModeList("envEnt"));
    }

    private List<NamedObjectModel> getNamedObjectModeList(String type) {
        type = "-" + type;
        ArrayList<NamedObjectModel> namedObjectModelList = new ArrayList<NamedObjectModel>();
        for (int i = 0; i < 2; ++i) {
            NamedObjectModel nom = new NamedObjectModel();
            nom.setIdentifier("id-" + i + type);
            nom.setName("name-" + i + type);
            String[] params = new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString()};
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.addAll(Arrays.asList(params));
            nom.setParameters(paramList);
            nom.setResolver(i + "-resolver" + type);
            namedObjectModelList.add(nom);
        }
        return namedObjectModelList;
    }

    @Test
    public void funnyCharactersTest() throws Exception {
        String testStr = "test &<>\"' test";
        JaxbString jaxbStr = new JaxbString(testStr);
        JaxbString copy = this.testRoundTrip(jaxbStr);
        AbstractRemoteSerializationTest.assertEquals((String)"Funny characters not correctly encoded", (Object)testStr, (Object)copy.getValue());
    }

    @Test
    public void correlationKeyTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbCorrelationKey corrKey = new JaxbCorrelationKey();
        corrKey.setName("anton");
        ArrayList<JaxbCorrelationProperty> properties = new ArrayList<JaxbCorrelationProperty>(3);
        corrKey.setJaxbProperties(properties);
        properties.add(new JaxbCorrelationProperty("name", "value"));
        properties.add(new JaxbCorrelationProperty("only-a-value"));
        properties.add(new JaxbCorrelationProperty("ngalan", "bili"));
        JaxbCorrelationKey copyCorrKey = this.testRoundTrip(corrKey);
        AbstractRemoteSerializationTest.assertEquals((String)"name", (Object)corrKey.getName(), (Object)copyCorrKey.getName());
        AbstractRemoteSerializationTest.assertEquals((String)"prop list size", (long)corrKey.getProperties().size(), (long)copyCorrKey.getProperties().size());
        List propList = corrKey.getProperties();
        List copyPropList = copyCorrKey.getProperties();
        for (int i = 0; i < propList.size(); ++i) {
            CorrelationProperty prop = (CorrelationProperty)propList.get(i);
            CorrelationProperty copyProp = (CorrelationProperty)copyPropList.get(i);
            AbstractRemoteSerializationTest.assertEquals((String)(i + ": name"), (Object)prop.getName(), (Object)copyProp.getName());
            AbstractRemoteSerializationTest.assertEquals((String)(i + ": type"), (Object)prop.getType(), (Object)copyProp.getType());
            AbstractRemoteSerializationTest.assertEquals((String)(i + ": value"), (Object)prop.getValue(), (Object)copyProp.getValue());
        }
    }

    @Test
    public void wrapperTypesTest() throws Exception {
        Object[] arrInputs;
        Object[] inputs;
        for (Object input : inputs = new Object[]{true, (byte)new Byte("1"), Character.valueOf(new Character('a').charValue()), (double)new Double(23.01), Float.valueOf(new Float(46.02).floatValue()), 1011, 1012, (short)new Short("10"), "string"}) {
            logger.debug("Testing round trip serialization in wrapper for " + input.getClass().getName());
            Object copyInput = this.wrapperRoundTrip(input);
            AbstractRemoteSerializationTest.assertEquals((String)(input.getClass().getSimpleName() + " wrapped round trip failed!"), (Object)input, (Object)copyInput);
        }
        Integer[] integerArr = new Integer[]{1039, 3858, 239502};
        int[] intArr = new int[]{1039, 3858, 239502};
        double[] doubleArr = new double[]{2.01, 3.02, 4.03};
        String[] stringArr = new String[]{"all", "about", "that", "base"};
        new JaxbArray((Object)doubleArr);
        for (Object input : arrInputs = new Object[]{intArr, integerArr, doubleArr, stringArr}) {
            logger.debug("Testing round trip serialization in wrapper for " + input.getClass().getName());
            int length = Array.getLength(input);
            Object copyInput = this.wrapperRoundTrip(input);
            AbstractRemoteSerializationTest.assertNotNull((String)("Null copy for " + input.getClass().getName()), (Object)copyInput);
            AbstractRemoteSerializationTest.assertEquals((String)"Array length", (long)Array.getLength(input), (long)Array.getLength(copyInput));
            for (int i = 0; i < length; ++i) {
                AbstractRemoteSerializationTest.assertEquals((String)("Element " + i + " inequal in " + input.getClass().getSimpleName() + " instance"), (Object)Array.get(input, i), (Object)Array.get(copyInput, i));
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        List copyList = this.wrapperRoundTrip(list);
        AbstractRemoteSerializationTest.assertEquals((String)(list.getClass().getSimpleName() + "round trip failed!"), list.iterator().next(), copyList.iterator().next());
        HashSet<String> set = new HashSet<String>();
        set.add("one");
        Set copySet = this.wrapperRoundTrip(set);
        AbstractRemoteSerializationTest.assertEquals((String)(set.getClass().getSimpleName() + "round trip failed!"), set.iterator().next(), copySet.iterator().next());
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("one", "two");
        Map copyMap = this.wrapperRoundTrip(map);
        AbstractRemoteSerializationTest.assertEquals((String)(copyMap.getClass().getSimpleName() + " round trip failed!"), map.get("one"), copyMap.get("one"));
    }

    private <T> T wrapperRoundTrip(T value) throws Exception {
        JaxbBoolean wrapper = null;
        if (value instanceof Boolean) {
            wrapper = new JaxbBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            wrapper = new JaxbByte((Byte)value);
        } else if (value instanceof Character) {
            wrapper = new JaxbCharacter((Character)value);
        } else if (value instanceof Double) {
            wrapper = new JaxbDouble((Double)value);
        } else if (value instanceof Float) {
            wrapper = new JaxbFloat((Float)value);
        } else if (value instanceof Integer) {
            wrapper = new JaxbInteger((Integer)value);
        } else if (value instanceof Long) {
            wrapper = new JaxbLong((Long)value);
        } else if (value instanceof Short) {
            wrapper = new JaxbShort((Short)value);
        } else if (value instanceof String) {
            wrapper = new JaxbString((String)value);
        } else if (value.getClass().isArray()) {
            wrapper = new JaxbArray(value);
        } else if (value instanceof List) {
            wrapper = new JaxbList((List)value);
        } else if (value instanceof Set) {
            wrapper = new JaxbSet((Set)value);
        } else if (value instanceof Map) {
            wrapper = new JaxbMap((Map)value);
        } else {
            AbstractRemoteSerializationTest.fail((String)("Modify the " + Thread.currentThread().getStackTrace()[1].getMethodName() + " to also round trip " + value.getClass().getSimpleName() + " instances!"));
        }
        return (T)((JaxbType)this.testRoundTrip(wrapper)).getValue();
    }

    protected static enum TestType {
        JAXB,
        JSON,
        YAML;

    }
}

