/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.services.client.serialization.AbstractRemoteSerializationTest;
import org.kie.services.client.serialization.JsonSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentDescriptor;
import org.kie.test.util.compare.ComparePair;

public class JsonRemoteSerializationTest
extends AbstractRemoteSerializationTest {
    protected JsonSerializationProvider jsonProvider = new JsonSerializationProvider();

    @Override
    public AbstractRemoteSerializationTest.TestType getType() {
        return AbstractRemoteSerializationTest.TestType.JSON;
    }

    @Override
    public <T> T testRoundTrip(T in) throws Exception {
        String jsonStr = this.jsonProvider.serialize(in);
        logger.debug(jsonStr);
        this.jsonProvider.setDeserializeOutputClass(in.getClass());
        return (T)this.jsonProvider.deserialize(jsonStr);
    }

    @Override
    public void addClassesToSerializationProvider(Class<?> ... extraClass) {
    }

    @Override
    @Test
    public void deploymentDescriptorTest() throws Exception {
        JaxbDeploymentDescriptor depDesc = new JaxbDeploymentDescriptor();
        depDesc.setAuditMode(AuditMode.JMS);
        depDesc.setAuditPersistenceUnit("per-unit");
        String[] classes = new String[]{"class"};
        depDesc.setRemoteableClasses(Arrays.asList(classes));
        NamedObjectModel[] nomArr = new NamedObjectModel[]{new NamedObjectModel("resol", "name", "class", new Object[]{"param-1"})};
        List<NamedObjectModel> noms = Arrays.asList(nomArr);
        depDesc.setConfiguration(noms);
        depDesc.setEnvironmentEntries(noms);
        ObjectModel[] omArr = new ObjectModel[]{new ObjectModel("asdf", "id", new Object[]{"param-1"})};
        List<ObjectModel> oms = Arrays.asList(omArr);
        depDesc.setEventListeners(oms);
        depDesc.setGlobals(noms);
        depDesc.setMarshallingStrategies(oms);
        depDesc.setPersistenceMode(PersistenceMode.JPA);
        depDesc.setPersistenceUnit("more-per-unit");
        String[] roles = new String[]{"chief", "chef", "cook"};
        depDesc.setRequiredRoles(Arrays.asList(roles));
        depDesc.setRuntimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        depDesc.setTaskEventListeners(oms);
        depDesc.setWorkItemHandlers(noms);
        JaxbDeploymentDescriptor copyDepDesc = this.testRoundTrip(depDesc);
        ComparePair.compareObjectsViaFields((Object)depDesc, (Object)copyDepDesc);
    }
}

