/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.jaxb;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.kie.services.client.AbstractServicesSerializationTest;
import org.kie.services.client.api.command.AcceptedCommands;
import org.kie.services.client.jaxb.JsonServicesSerializationTest;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.AbstractJaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;

public class JaxbServicesSerializationTest
extends AbstractServicesSerializationTest {
    private static Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)"org.kie.services.client", (ClassLoader[])new ClassLoader[0]), new TypeAnnotationsScanner(), new FieldAnnotationsScanner(), new MethodAnnotationsScanner(), new SubTypesScanner()});
    protected JaxbSerializationProvider jaxbProvider = new JaxbSerializationProvider();

    public JaxbServicesSerializationTest() {
        this.jaxbProvider.setPrettyPrint(true);
    }

    @Override
    public AbstractServicesSerializationTest.TestType getType() {
        return AbstractServicesSerializationTest.TestType.JAXB;
    }

    @Override
    public void addClassesToSerializationProvider(Class<?> ... extraClass) {
        this.jaxbProvider.addJaxbClasses((Class[])extraClass);
    }

    @Override
    public Object testRoundTrip(Object in) throws Exception {
        String xmlObject = this.jaxbProvider.serialize(in);
        logger.debug(xmlObject);
        return this.jaxbProvider.deserialize((Object)xmlObject);
    }

    @Test
    public void acceptedCommandsTest() throws Exception {
        for (Class cmdClass : AcceptedCommands.getSet()) {
            try {
                cmdClass.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                Assert.fail((String)("Class " + cmdClass.getSimpleName() + " does not have a no-arg constructor."));
            }
        }
    }

    @Test
    public void jaxbClassesAreKnownToJaxbSerializationProvider() throws Exception {
        for (Class jaxbClass : reflections.getTypesAnnotatedWith(XmlRootElement.class)) {
            Constructor construct = jaxbClass.getConstructor(new Class[0]);
            Object jaxbInst = construct.newInstance(new Object[0]);
            this.testRoundTrip(jaxbInst);
        }
    }

    @Test
    public void acceptedCommandsCanBeSerializedTest() throws Exception {
        Assume.assumeTrue((boolean)this.getType().equals((Object)AbstractServicesSerializationTest.TestType.JAXB));
        Field commandsField = JaxbCommandsRequest.class.getDeclaredField("commands");
        XmlElements xmlElemsAnno = (XmlElements)commandsField.getAnnotations()[0];
        XmlElement[] xmlElems = xmlElemsAnno.value();
        HashSet cmdSet = new HashSet(AcceptedCommands.getSet());
        Assert.assertEquals((String)(AcceptedCommands.class.getSimpleName() + " contains a different set of Commands than " + JaxbCommandsRequest.class.getSimpleName()), (long)cmdSet.size(), (long)xmlElems.length);
        HashSet<String> xmlElemNameSet = new HashSet<String>();
        for (XmlElement xmlElemAnno : xmlElems) {
            Class cmdClass = xmlElemAnno.type();
            String name = xmlElemAnno.name();
            Assert.assertTrue((String)(name + " is used twice as a name."), (boolean)xmlElemNameSet.add(name));
            Assert.assertTrue((String)(cmdClass.getSimpleName() + " is present in " + AcceptedCommands.class.getSimpleName() + " but not in " + JaxbCommandsRequest.class.getSimpleName()), (boolean)cmdSet.remove(cmdClass));
        }
        for (Class cmdClass : cmdSet) {
            logger.error("Missing: " + cmdClass.getSimpleName());
        }
        Assert.assertEquals((String)("See output for classes in " + AcceptedCommands.class.getSimpleName() + " that are not in " + JaxbCommandsRequest.class.getSimpleName()), (long)0L, (long)cmdSet.size());
    }

    @Test
    public void allCommandResponseTypesNeedXmlElemIdTest() throws Exception {
        Field commandsField = JaxbCommandsResponse.class.getDeclaredField("responses");
        XmlElements xmlElemsAnno = (XmlElements)commandsField.getAnnotations()[0];
        XmlElement[] xmlElems = xmlElemsAnno.value();
        HashSet<Class> cmdSet = new HashSet<Class>();
        for (Class cmdRespImpl : reflections.getSubTypesOf(JaxbCommandResponse.class)) {
            cmdSet.add(cmdRespImpl);
        }
        cmdSet.remove(AbstractJaxbCommandResponse.class);
        int numAnnos = xmlElems.length;
        int numClass = cmdSet.size();
        HashSet<String> xmlElemNameSet = new HashSet<String>();
        for (XmlElement xmlElemAnno : xmlElems) {
            Class cmdClass = xmlElemAnno.type();
            String name = xmlElemAnno.name();
            Assert.assertTrue((String)(name + " is used twice as a name."), (boolean)xmlElemNameSet.add(name));
            Assert.assertTrue((String)(cmdClass.getSimpleName() + " is present in " + JaxbCommandsResponse.class.getSimpleName() + " but does not " + "implement " + JaxbCommandResponse.class.getSimpleName()), (boolean)cmdSet.remove(cmdClass));
        }
        for (Class cmdClass : cmdSet) {
            logger.error("Missing: " + cmdClass.getSimpleName());
        }
        Assert.assertTrue((String)("See above output for difference between " + JaxbCommandResponse.class.getSimpleName() + " implementations " + "and classes listed in " + JaxbCommandsResponse.class.getSimpleName()), (cmdSet.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)((numClass > numAnnos ? "Not all classes" : "Non " + JaxbCommandResponse.class.getSimpleName() + " classes") + " are listed in the " + JaxbCommandResponse.class.getSimpleName() + ".response @XmlElements list."), (long)numClass, (long)numAnnos);
    }

    @Test
    public void uniqueRootElementTest() throws Exception {
        Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)"org.jbpm.kie.services.client", (ClassLoader[])new ClassLoader[0]), new TypeAnnotationsScanner(), new FieldAnnotationsScanner(), new MethodAnnotationsScanner()});
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, Class> idClassMap = new HashMap<String, Class>();
        for (Class jaxbClass : reflections.getTypesAnnotatedWith(XmlRootElement.class)) {
            XmlRootElement rootElemAnno = jaxbClass.getAnnotation(XmlRootElement.class);
            String id = rootElemAnno.name();
            if ("##default".equals(id)) continue;
            String otherClass = idClassMap.get(id) == null ? "null" : ((Class)idClassMap.get(id)).getName();
            Assert.assertTrue((String)("ID '" + id + "' used in both " + jaxbClass.getName() + " and " + otherClass), (boolean)idSet.add(id));
            idClassMap.put(id, jaxbClass);
        }
    }

    @Test
    public void classListPropertyTest() throws Exception {
        String in = "1";
        String[] out = JaxbSerializationProvider.split((String)in);
        Assert.assertEquals((long)1L, (long)out.length);
        Assert.assertEquals((Object)"1", (Object)out[0]);
        String again = this.join(out);
        Assert.assertEquals((Object)in, (Object)again);
        out = JaxbSerializationProvider.split((String)" 1 ");
        Assert.assertEquals((long)1L, (long)out.length);
        Assert.assertEquals((Object)"1", (Object)out[0]);
        again = this.join(out);
        Assert.assertEquals((Object)"1", (Object)again);
        out = JaxbSerializationProvider.split((String)"1,2");
        Assert.assertEquals((long)2L, (long)out.length);
        Assert.assertEquals((Object)"1", (Object)out[0]);
        Assert.assertEquals((Object)"2", (Object)out[1]);
        again = this.join(out);
        Assert.assertEquals((Object)again, (Object)"1,2");
        out = JaxbSerializationProvider.split((String)" 1,2 ");
        Assert.assertEquals((long)2L, (long)out.length);
        Assert.assertEquals((Object)"1", (Object)out[0]);
        Assert.assertEquals((Object)"2", (Object)out[1]);
        out[0] = "1 ";
        out[1] = " 2";
        again = this.join(out);
        Assert.assertEquals((Object)"1,2", (Object)again);
        out = JaxbSerializationProvider.split((String)" 1, ");
        Assert.assertEquals((long)out.length, (long)1L);
        Assert.assertEquals((Object)out[0], (Object)"1");
        out[0] = "1 ";
        again = this.join(out);
        Assert.assertEquals((Object)"1", (Object)again);
        out = JaxbSerializationProvider.split((String)" , 2   ");
        Assert.assertEquals((long)out.length, (long)1L);
        Assert.assertEquals((Object)out[0], (Object)"2");
        out[0] = "2 ";
        again = this.join(out);
        Assert.assertEquals((Object)"2", (Object)again);
        out = JaxbSerializationProvider.split((String)" ,    ");
        Assert.assertEquals((long)out.length, (long)0L);
        again = this.join(out);
        Assert.assertEquals((Object)"", (Object)again);
        HashSet<Class<Long>> classList = new HashSet<Class<Long>>();
        classList.add(String.class);
        classList.add(Integer.class);
        classList.add(Byte.class);
        classList.add(Short.class);
        classList.add(Long.class);
        String commaString = JaxbSerializationProvider.classSetToCommaSeperatedString(classList);
        Set copyClasses = JaxbSerializationProvider.commaSeperatedStringToClassSet((String)commaString);
        Assert.assertEquals(classList, (Object)copyClasses);
        String newCommaString = JaxbSerializationProvider.classSetToCommaSeperatedString((Collection)copyClasses);
        Assert.assertEquals((long)commaString.length(), (long)newCommaString.length());
    }

    private String join(String[] inArr) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < inArr.length; ++i) {
            String temp = inArr[i].trim();
            if (temp.isEmpty()) continue;
            if (out.length() > 0) {
                out.append(",");
            }
            out.append(temp);
        }
        return out.toString();
    }

    @Test
    public void jmsSerializationPropertyTest() {
        HashSet extraJaxbClasses = new HashSet();
        this.testRoundTripClassesSet(extraJaxbClasses);
        extraJaxbClasses.add(JaxbServicesSerializationTest.class);
        this.testRoundTripClassesSet(extraJaxbClasses);
        extraJaxbClasses.add(JsonServicesSerializationTest.class);
        this.testRoundTripClassesSet(extraJaxbClasses);
    }

    private void testRoundTripClassesSet(Set<Class<?>> extraJaxbClasses) {
        boolean emptySet = extraJaxbClasses.isEmpty();
        Assert.assertNotNull((String)"Test class set is null!", extraJaxbClasses);
        String classesStrProp = JaxbSerializationProvider.classSetToCommaSeperatedString(extraJaxbClasses);
        Assert.assertNotNull((String)"Classes list string is null!", (Object)classesStrProp);
        Assert.assertTrue((String)"Classes list string is incorrectly formatted!", (!(classesStrProp.isEmpty() && !emptySet || classesStrProp.contains(" ") || classesStrProp.length() <= 10 && !emptySet) ? 1 : 0) != 0);
        Set copyExtraJaxbClasses = JaxbSerializationProvider.commaSeperatedStringToClassSet((String)classesStrProp);
        Assert.assertNotNull((String)"Round-tripped classes set is null!", (Object)copyExtraJaxbClasses);
        Assert.assertTrue((String)"Round-tripped classes set is empty!", (!copyExtraJaxbClasses.isEmpty() || emptySet ? 1 : 0) != 0);
        Assert.assertEquals((String)"Round-tripped classes size is incorrect!", (long)extraJaxbClasses.size(), (long)copyExtraJaxbClasses.size());
        for (Class<?> origClass : extraJaxbClasses) {
            Assert.assertTrue((String)("Round-tripped class set did not contain " + origClass.getSimpleName()), (boolean)copyExtraJaxbClasses.remove(origClass));
        }
        Assert.assertTrue((String)("There is " + copyExtraJaxbClasses.size() + " class left over in the round-tripped class set!"), (boolean)copyExtraJaxbClasses.isEmpty());
    }
}

