/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.drools.core.SessionConfiguration;
import org.drools.core.command.runtime.process.GetProcessInstanceByCorrelationKeyCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.correlation.CorrelationPropertyInfo;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.FindProcessInstanceCommand;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.services.task.commands.GetTaskAssignedAsBusinessAdminCommand;
import org.jbpm.services.task.commands.GetTasksByProcessInstanceIdCommand;
import org.jbpm.services.task.commands.StartTaskCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.jaxb.ComparePair;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.After;
import org.junit.Assume;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.command.Command;
import org.kie.api.definition.KieDefinition;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbOtherResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbNodeInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbVariableInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceListResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItem;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummaryListResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbRequestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServicesSerializationTest
extends JbpmJUnitBaseTestCase {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractServicesSerializationTest.class);

    public abstract TestType getType();

    public abstract void addClassesToSerializationProvider(Class<?> ... var1);

    public abstract <T> T testRoundTrip(T var1) throws Exception;

    private Object getField(String fieldName, Class<?> clazz, Object obj) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    private static KieSession createKnowledgeSession(String processFile) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        if (processFile != null) {
            Resource process = ResourceFactory.newClassPathResource((String)processFile);
            kfs.write(process);
        }
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        KieBase kbase = kContainer.getKieBase();
        Environment env = EnvironmentFactory.newEnvironment();
        Properties defaultProps = new Properties();
        defaultProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
        defaultProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        SessionConfiguration conf = new SessionConfiguration(defaultProps);
        StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)kbase.newKieSession((KieSessionConfiguration)conf, env);
        return ksession;
    }

    @After
    public void after() throws Exception {
        super.tearDown();
        this.setupDataSource = false;
        this.sessionPersistence = false;
    }

    @Test
    public void commandRequestTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.JSON));
        String userId = "krisv";
        long taskId = 1L;
        StartTaskCommand cmd = new StartTaskCommand(taskId, "krisv");
        JaxbCommandsRequest req = new JaxbCommandsRequest("test", (Command)cmd);
        Command newCmd = (Command)this.testRoundTrip(req).getCommands().get(0);
        AbstractServicesSerializationTest.assertNotNull((Object)newCmd);
        AbstractServicesSerializationTest.assertEquals((String)"taskId is not equal", (Object)taskId, (Object)this.getField("taskId", TaskCommand.class, newCmd));
        AbstractServicesSerializationTest.assertEquals((String)"userId is not equal", (Object)userId, (Object)this.getField("userId", TaskCommand.class, newCmd));
        req = new JaxbCommandsRequest();
        req.setUser("krampus");
        ArrayList<StartProcessCommand> cmds = new ArrayList<StartProcessCommand>();
        req.setCommands(cmds);
        req.setDeploymentId("depId");
        req.setProcessInstanceId(Long.valueOf(43L));
        req.setVersion("6.0.1.0");
        StartProcessCommand spCmd = new StartProcessCommand("test.proc.yaml");
        cmds.add(spCmd);
        spCmd.getParameters().put("one", "a");
        spCmd.getParameters().put("two", "B");
        Integer[] weirdParam = new Integer[]{59, 2195};
        spCmd.getParameters().put("thr", weirdParam);
        this.addClassesToSerializationProvider(weirdParam.getClass());
        JaxbCommandsRequest newReq = this.testRoundTrip(req);
        AbstractServicesSerializationTest.assertEquals(((StartProcessCommand)newReq.getCommands().get(0)).getParameters().get("two"), (Object)"B");
        req = new JaxbCommandsRequest("deployment", (Command)new StartProcessCommand("org.jbpm.humantask"));
        newReq = this.testRoundTrip(req);
        CorrelationKeyInfo corrKey = new CorrelationKeyInfo();
        corrKey.addProperty(new CorrelationPropertyInfo("null", "val"));
        GetProcessInstanceByCorrelationKeyCommand gpibckCmd = new GetProcessInstanceByCorrelationKeyCommand((CorrelationKey)corrKey);
        req = new JaxbCommandsRequest("test", (Command)gpibckCmd);
        this.testRoundTrip(req);
    }

    @Test
    public void commandsResponseTest() throws Exception {
        this.setupDataSource = true;
        this.sessionPersistence = true;
        super.setUp();
        RuntimeEngine runtimeEngine = this.createRuntimeManager(new String[]{"BPMN2-StringStructureRef.bpmn2"}).getRuntimeEngine(null);
        KieSession ksession = runtimeEngine.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        String val = "initial-val";
        params.put("test", val);
        StartProcessCommand cmd = new StartProcessCommand("StructureRef");
        cmd.setParameters(params);
        ProcessInstance processInstance = (ProcessInstance)ksession.execute((Command)cmd);
        AbstractServicesSerializationTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        JaxbCommandsResponse resp = new JaxbCommandsResponse();
        resp.setDeploymentId("deploy");
        resp.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        resp.addResult((Object)processInstance, 0, (Command)cmd);
        this.testRoundTrip(resp);
        cmd = new GetTaskAssignedAsBusinessAdminCommand();
        ArrayList result = new ArrayList();
        resp = new JaxbCommandsResponse();
        resp.addResult(result, 0, (Command)cmd);
        cmd = new GetTasksByProcessInstanceIdCommand();
        ArrayList resultTwo = new ArrayList();
        resp.addResult(resultTwo, 1, (Command)cmd);
        JaxbCommandsResponse newResp = this.testRoundTrip(resp);
        AbstractServicesSerializationTest.assertNotNull((Object)newResp);
        AbstractServicesSerializationTest.assertEquals((long)2L, (long)newResp.getResponses().size());
    }

    @Test
    public void taskSummaryListTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        this.setupDataSource = true;
        this.sessionPersistence = true;
        super.setUp();
        RuntimeManager runtimeManager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.SINGLETON, "test", new String[]{"BPMN2-HumanTaskWithTaskContent.bpmn2"});
        RuntimeEngine runtimeEngine = runtimeManager.getRuntimeEngine(null);
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance procInst = ksession.startProcess("org.kie.remote.test.usertask.UserTask");
        long procInstId = procInst.getId();
        ArrayList<Long> statuses = new ArrayList<Long>();
        statuses.add(procInstId);
        HashMap<String, ArrayList<Long>> fieldVals = new HashMap<String, ArrayList<Long>>();
        fieldVals.put("process instance id list", statuses);
        List taskSumList = ((InternalTaskService)taskService).getTasksByVariousFields(fieldVals, true);
        AbstractServicesSerializationTest.assertEquals((String)"Task summary list size", (long)1L, (long)taskSumList.size());
        TaskSummaryImpl taskSumImpl = (TaskSummaryImpl)taskSumList.get(0);
        taskSumImpl.setActualOwner((User)new UserImpl("Minnie"));
        taskSumImpl.setCreatedBy((User)new UserImpl("Mickey"));
        JaxbTaskSummaryListResponse jaxbTaskSumListResp = new JaxbTaskSummaryListResponse((Collection)taskSumList);
        JaxbTaskSummaryListResponse jaxbTaskSumListRespCopy = this.testRoundTrip(jaxbTaskSumListResp);
        AbstractServicesSerializationTest.assertEquals((long)jaxbTaskSumListResp.getList().size(), (long)jaxbTaskSumListRespCopy.getList().size());
        TaskSummary taskSum = (TaskSummary)jaxbTaskSumListResp.getList().get(0);
        TaskSummary taskSumCopy = (TaskSummary)jaxbTaskSumListRespCopy.getList().get(0);
        ComparePair.compareObjectsViaFields((Object)taskSum, (Object)taskSumCopy, (String[])new String[]{"potentialOwners", "createdOn", "activationTime", "expirationTime", "subTaskStrategy"});
    }

    @Test
    public void genericResponseTest() throws Exception {
        JaxbGenericResponse resp = new JaxbGenericResponse();
        resp.setMessage("error");
        resp.setStatus(JaxbRequestStatus.SUCCESS);
        resp.setUrl("http://here");
        this.testRoundTrip(resp);
    }

    @Test
    public void exceptionTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbExceptionResponse resp = new JaxbExceptionResponse();
        resp.setMessage("error");
        resp.setStatus(JaxbRequestStatus.SUCCESS);
        resp.setUrl("http://here");
        RuntimeException re = new RuntimeException();
        resp.setCause((Exception)re);
        this.testRoundTrip(resp);
    }

    @Test
    public void variablesResponseTest() throws Exception {
        JaxbVariablesResponse resp = new JaxbVariablesResponse();
        this.testRoundTrip(resp);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("one", "two");
        resp.setVariables(vars);
        this.testRoundTrip(resp);
    }

    @Test
    public void historyLogListTest() throws Exception {
        JaxbHistoryLogList resp = new JaxbHistoryLogList();
        this.testRoundTrip(resp);
        VariableInstanceLog vLog = new VariableInstanceLog(23L, "process", "varInst", "var", "two", "one");
        vLog.setExternalId("domain");
        Field dateField = VariableInstanceLog.class.getDeclaredField("date");
        dateField.setAccessible(true);
        dateField.set(vLog, new Date());
        Field idField = VariableInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(vLog, 32L);
        resp.getHistoryLogList().add(new JaxbVariableInstanceLog(vLog));
        ProcessInstanceLog pLog = new ProcessInstanceLog(23L, "process");
        pLog.setDuration(Long.valueOf(2000L));
        pLog.setEnd(new Date());
        pLog.setExternalId("domain");
        pLog.setIdentity("id");
        pLog.setOutcome("error");
        pLog.setParentProcessInstanceId(42L);
        pLog.setProcessName("name");
        pLog.setProcessVersion("1-SNAP");
        pLog.setStatus(2);
        idField = ProcessInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(pLog, 32L);
        resp.getHistoryLogList().add(new JaxbProcessInstanceLog(pLog));
        NodeInstanceLog nLog = new NodeInstanceLog(0, 23L, "process", "nodeInst", "node", "wally");
        idField = NodeInstanceLog.class.getDeclaredField("id");
        idField.setAccessible(true);
        idField.set(nLog, 32L);
        dateField = NodeInstanceLog.class.getDeclaredField("date");
        dateField.setAccessible(true);
        dateField.set(nLog, new Date());
        nLog.setNodeType("type");
        nLog.setWorkItemId(Long.valueOf(88L));
        nLog.setConnection("connex");
        nLog.setExternalId("domain");
        resp.getHistoryLogList().add(new JaxbNodeInstanceLog(nLog));
        this.testRoundTrip(resp);
    }

    @Test
    public void auditCommandsTest() throws Exception {
        FindProcessInstanceCommand cmd = new FindProcessInstanceCommand(23L);
        this.testRoundTrip(cmd);
    }

    @Test
    public void factHandleTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        KieSession ksession = AbstractServicesSerializationTest.createKnowledgeSession(null);
        InsertObjectCommand cmd = new InsertObjectCommand((Object)"The Sky is Green");
        FactHandle factHandle = (FactHandle)ksession.execute((Command)cmd);
        JaxbOtherResponse jor = new JaxbOtherResponse((Object)factHandle, 0, (Command)cmd);
        this.testRoundTrip(jor);
    }

    @Test
    public void processInstanceWithVariablesTest() throws Exception {
        this.setupDataSource = true;
        this.sessionPersistence = true;
        super.setUp();
        RuntimeEngine runtimeEngine = this.createRuntimeManager(new String[]{"BPMN2-StringStructureRef.bpmn2"}).getRuntimeEngine(null);
        KieSession ksession = runtimeEngine.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        String val = "initial-val";
        params.put("test", val);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        AbstractServicesSerializationTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "initial-val");
        JaxbProcessInstanceWithVariablesResponse jpiwvr = new JaxbProcessInstanceWithVariablesResponse(processInstance, map);
        this.testRoundTrip(jpiwvr);
        JaxbProcessInstanceListResponse jpilp = new JaxbProcessInstanceListResponse();
        ArrayList<JaxbProcessInstanceResponse> procInstList = new ArrayList<JaxbProcessInstanceResponse>();
        procInstList.add(new JaxbProcessInstanceResponse(processInstance));
        jpilp.setResult(procInstList);
        this.testRoundTrip(jpilp);
    }

    @Test
    public void workItemObjectTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbWorkItem workitemObject = new JaxbWorkItem();
        workitemObject.setId(Long.valueOf(35L));
        workitemObject.setName("Clau");
        workitemObject.setState(Integer.valueOf(0));
        workitemObject.setProcessInstanceId(Long.valueOf(1L));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "driving");
        workitemObject.setParameters(params);
        JaxbWorkItem roundTripWorkItem = this.testRoundTrip(workitemObject);
        ComparePair.compareObjectsViaFields((Object)workitemObject, (Object)roundTripWorkItem);
    }

    @Test
    public void serializingPrimitiveArraysTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.JSON));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("url", "http://soaptest.parasoft.com/calculator.wsdl");
        parameters.put("namespace", "http://www.parasoft.com/wsdl/calculator/");
        parameters.put("interface", "Calculator");
        parameters.put("operation", "add");
        Float[] arrayParam = new Float[]{Float.valueOf(9.0f), Float.valueOf(12.0f)};
        parameters.put("parameters", arrayParam);
        this.addClassesToSerializationProvider(arrayParam.getClass());
        StartProcessCommand cmd = new StartProcessCommand("proc.with.array.params", parameters);
        JaxbCommandsRequest req = new JaxbCommandsRequest("test", (Command)cmd);
        Command newCmd = (Command)this.testRoundTrip(req).getCommands().get(0);
        AbstractServicesSerializationTest.assertNotNull((Object)newCmd);
    }

    @Test
    public void nodeInstanceLogNpeTest() throws Exception {
        NodeInstanceLog nodeLog = new NodeInstanceLog();
        JaxbNodeInstanceLog jaxbNodeLog = new JaxbNodeInstanceLog(nodeLog);
        this.testRoundTrip(jaxbNodeLog);
    }

    @Test
    public void deploymentObjectsTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        JaxbDeploymentUnitList depUnitList = new JaxbDeploymentUnitList();
        JaxbDeploymentJobResult jaxbJob = new JaxbDeploymentJobResult();
        this.testRoundTrip(jaxbJob);
        KModuleDeploymentUnit kDepUnit = new KModuleDeploymentUnit("org", "jar", "1.0", "kbase", "ksession");
        kDepUnit.setStrategy(DeploymentUnit.RuntimeStrategy.PER_PROCESS_INSTANCE);
        JaxbDeploymentUnit depUnit = new JaxbDeploymentUnit(kDepUnit.getGroupId(), kDepUnit.getArtifactId(), kDepUnit.getArtifactId());
        depUnit.setKbaseName(kDepUnit.getKbaseName());
        depUnit.setKsessionName(kDepUnit.getKsessionName());
        depUnit.setStrategy(kDepUnit.getStrategy());
        depUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.NONEXISTENT);
        depUnitList.getDeploymentUnitList().add(depUnit);
        jaxbJob = new JaxbDeploymentJobResult(null, "test", depUnit, "deploy");
        jaxbJob.setIdentifier(Long.valueOf(23L));
        jaxbJob.setSuccess(Boolean.valueOf(false));
        JaxbDeploymentJobResult copyJaxbJob = this.testRoundTrip(jaxbJob);
        ComparePair.compareObjectsViaFields((Object)jaxbJob, (Object)copyJaxbJob, (String[])new String[]{"jobId", "identifier"});
        depUnit = new JaxbDeploymentUnit("g", "a", "v");
        depUnit.setKbaseName("kbase");
        depUnit.setKsessionName("ksession");
        depUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED);
        depUnit.setStrategy(DeploymentUnit.RuntimeStrategy.PER_PROCESS_INSTANCE);
        depUnitList.getDeploymentUnitList().add(depUnit);
        JaxbDeploymentUnit copyDepUnit = this.testRoundTrip(depUnit);
        ComparePair.compareObjectsViaFields((Object)depUnit, (Object)copyDepUnit, (String[])new String[]{"identifier"});
        JaxbDeploymentJobResult depJob = new JaxbDeploymentJobResult(null, "testing stuff", copyDepUnit, "test");
        depJob.setSuccess(Boolean.valueOf(true));
        JaxbDeploymentJobResult copyDepJob = this.testRoundTrip(depJob);
        ComparePair.compareObjectsViaFields((Object)copyDepJob, (Object)depJob, (String[])new String[]{"jobId", "identifier"});
        JaxbDeploymentUnitList roundTripUnitList = this.testRoundTrip(depUnitList);
        ComparePair.compareObjectsViaFields(depUnitList.getDeploymentUnitList().get(0), roundTripUnitList.getDeploymentUnitList().get(0), (String[])new String[]{"jobId", "identifier"});
    }

    @Test
    public void processInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        ProcessInstanceLog origLog = new ProcessInstanceLog(54L, "org.hospital.patient.triage");
        origLog.setDuration(Long.valueOf(65L));
        origLog.setDuration(Long.valueOf(234L));
        origLog.setEnd(new Date(new Date().getTime() + 1000L));
        origLog.setExternalId("testDomainId");
        origLog.setIdentity("identityNotMemory");
        origLog.setStatus(2);
        origLog.setOutcome("descriptiveErrorCodeOfAnError");
        origLog.setParentProcessInstanceId(65L);
        origLog.setProcessName("org.process.not.technical");
        origLog.setProcessVersion("v3.14");
        JaxbProcessInstanceLog xmlLog = new JaxbProcessInstanceLog(origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        JaxbProcessInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareOrig((Object)xmlLog, (Object)newXmlLog, JaxbProcessInstanceLog.class);
        ProcessInstanceLog newLog = newXmlLog.getResult();
        ComparePair.compareOrig((Object)origLog, (Object)newLog, ProcessInstanceLog.class);
    }

    @Test
    public void processInstanceLogNillable() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        ProcessInstanceLog origLog = new ProcessInstanceLog(54L, "org.hospital.patient.triage");
        origLog.setDuration(Long.valueOf(65L));
        origLog.setEnd(new Date(new Date().getTime() + 1000L));
        origLog.setExternalId("testDomainId");
        origLog.setIdentity("identityNotMemory");
        origLog.setProcessName("org.process.not.technical");
        origLog.setProcessVersion("v3.14");
        JaxbProcessInstanceLog xmlLog = new JaxbProcessInstanceLog(origLog);
        JaxbProcessInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getProcessInstanceId(), (Object)newXmlLog.getProcessInstanceId());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getProcessId(), (Object)newXmlLog.getProcessId());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getDuration(), (Object)newXmlLog.getDuration());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getEnd(), (Object)newXmlLog.getEnd());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getExternalId(), (Object)newXmlLog.getExternalId());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getIdentity(), (Object)newXmlLog.getIdentity());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getStatus(), (Object)newXmlLog.getStatus());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getOutcome(), (Object)newXmlLog.getOutcome());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getParentProcessInstanceId(), (Object)newXmlLog.getParentProcessInstanceId());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getProcessName(), (Object)newXmlLog.getProcessName());
        AbstractServicesSerializationTest.assertEquals((Object)xmlLog.getProcessVersion(), (Object)newXmlLog.getProcessVersion());
    }

    @Test
    public void nodeInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        int type = 0;
        long processInstanceId = 23L;
        String processId = "org.hospital.doctor.review";
        String nodeInstanceId = "1-1";
        String nodeId = "1";
        String nodeName = "notification";
        NodeInstanceLog origLog = new NodeInstanceLog(type, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        origLog.setWorkItemId(Long.valueOf(78L));
        origLog.setConnection("link");
        origLog.setExternalId("not-internal-num");
        origLog.setNodeType("the-sort-of-point");
        JaxbNodeInstanceLog xmlLog = new JaxbNodeInstanceLog(origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        JaxbNodeInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareOrig((Object)xmlLog, (Object)newXmlLog, JaxbNodeInstanceLog.class);
        NodeInstanceLog newLog = newXmlLog.getResult();
        ComparePair.compareOrig((Object)origLog, (Object)newLog, NodeInstanceLog.class);
    }

    @Test
    public void variableInstanceLogTest() throws Exception {
        Assume.assumeFalse((boolean)this.getType().equals((Object)TestType.YAML));
        long processInstanceId = 23L;
        String processId = "org.hospital.intern.rounds";
        String variableInstanceId = "patientNum-1";
        String variableId = "patientNum";
        String value = "33";
        String oldValue = "32";
        VariableInstanceLog origLog = new VariableInstanceLog(processInstanceId, processId, variableInstanceId, variableId, value, oldValue);
        origLog.setExternalId("outside-identity-representation");
        origLog.setOldValue("previous-data-that-this-variable-contains");
        origLog.setValue("the-new-data-that-has-been-put-in-this-variable");
        origLog.setVariableId("shortend-representation-of-this-representation");
        origLog.setVariableInstanceId("id-instance-variable");
        JaxbVariableInstanceLog xmlLog = new JaxbVariableInstanceLog(origLog);
        xmlLog.setCommandName("test-cmd");
        xmlLog.setIndex(Integer.valueOf(2));
        JaxbVariableInstanceLog newXmlLog = this.testRoundTrip(xmlLog);
        ComparePair.compareOrig((Object)xmlLog, (Object)newXmlLog, JaxbVariableInstanceLog.class);
        VariableInstanceLog newLog = newXmlLog.getResult();
        ComparePair.compareOrig((Object)origLog, (Object)newLog, VariableInstanceLog.class);
    }

    @Test
    public void processIdAndProcessDefinitionTest() throws Exception {
        ProcessAssetDesc assetDesc = new ProcessAssetDesc("org.test.proc.id", "The Name Of The Process", "1.999.23.Final", "org.test.proc", "RuleFlow", KieDefinition.KnowledgeType.PROCESS.toString(), "org.test.proc", "org.test.proc:procs:1.999.Final");
        JaxbProcessDefinition jaxbProcDef = new JaxbProcessDefinition();
        jaxbProcDef.setDeploymentId(assetDesc.getDeploymentId());
        jaxbProcDef.setId(assetDesc.getId());
        jaxbProcDef.setName(assetDesc.getName());
        jaxbProcDef.setPackageName(assetDesc.getPackageName());
        jaxbProcDef.setVersion(assetDesc.getVersion());
        HashMap<String, String> forms = new HashMap<String, String>();
        forms.put("locationForm", "GPS: street: post code: city: state: land: planet: universe: ");
        jaxbProcDef.setForms(forms);
        JaxbProcessDefinition copyJaxbProcDef = this.testRoundTrip(jaxbProcDef);
        ComparePair.compareObjectsViaFields((Object)jaxbProcDef, (Object)copyJaxbProcDef);
    }

    protected static enum TestType {
        JAXB,
        JSON,
        YAML;

    }
}

