/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.jaxb;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsBusinessAdminCommand;
import org.jbpm.services.task.commands.GetTasksByProcessInstanceIdCommand;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedJaxbCommandsRequestResponseTest {
    protected static final Logger logger = LoggerFactory.getLogger(VersionedJaxbCommandsRequestResponseTest.class);
    protected JaxbSerializationProvider jaxbProvider = new JaxbSerializationProvider();
    String cmdReqXmlStr;
    String cmdRespXmlStr;

    public VersionedJaxbCommandsRequestResponseTest() {
        this.jaxbProvider.setPrettyPrint(true);
        this.cmdReqXmlStr = "<command-request>    <deployment-id>depId</deployment-id>    <process-instance-id>43</process-instance-id>    <ver>2</ver>    <user>krampus</user>    <start-process processId=\"test.proc.yaml\">        <parameter>            <item key=\"two\">                <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">B</value>            </item>            <item key=\"thr\">                <value xsi:type=\"ns3:intArray\" xmlns:ns3=\"http://jaxb.dev.java.net/array\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">                    <item>59</item>                    <item>2195</item>                </value>            </item>            <item key=\"one\">                <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">a</value>            </item>        </parameter>    </start-process></command-request>";
        this.cmdRespXmlStr = "<command-response>    <ver>1</ver>    <task-summary-list index=\"0\">        <command-name>GetTaskAssignedAsBusinessAdminCommand</command-name>    </task-summary-list>    <long-list index=\"1\">        <command-name>GetTasksByProcessInstanceIdCommand</command-name>    </long-list></command-response>";
    }

    public <T> T testRoundTrip(T in) throws Exception {
        String xmlStr = this.jaxbProvider.serialize(in);
        logger.debug(xmlStr);
        return (T)this.deserialize(xmlStr);
    }

    public Object deserialize(String xmlStr) {
        return this.jaxbProvider.deserialize((Object)xmlStr);
    }

    @Test
    public void commandRequestTest() throws Exception {
        JaxbCommandsRequest req = new JaxbCommandsRequest();
        req.setUser("krampus");
        ArrayList<StartProcessCommand> cmds = new ArrayList<StartProcessCommand>();
        req.setCommands(cmds);
        req.setDeploymentId("depId");
        req.setProcessInstanceId(Long.valueOf(43L));
        req.setVersion("2");
        StartProcessCommand spCmd = new StartProcessCommand("test.proc.yaml");
        cmds.add(spCmd);
        spCmd.getParameters().put("one", "a");
        spCmd.getParameters().put("two", "B");
        Integer[] weirdParam = new Integer[]{59, 2195};
        spCmd.getParameters().put("thr", weirdParam);
        JaxbCommandsRequest newReq = this.testRoundTrip(req);
        Assert.assertEquals(((StartProcessCommand)newReq.getCommands().get(0)).getParameters().get("two"), (Object)"B");
        Object newStringReq = this.deserialize(this.cmdReqXmlStr);
        Assert.assertNotNull((Object)newStringReq);
        Assert.assertEquals((long)1L, (long)((JaxbCommandsRequest)newStringReq).getCommands().size());
        Command newCmd = (Command)((JaxbCommandsRequest)newStringReq).getCommands().get(0);
    }

    @Test
    public void commandsResponseTest() throws Exception {
        GetTaskAssignedAsBusinessAdminCommand cmd = new GetTaskAssignedAsBusinessAdminCommand();
        ArrayList result = new ArrayList();
        JaxbCommandsResponse resp = new JaxbCommandsResponse();
        resp.addResult(result, 0, (Command)cmd);
        cmd = new GetTasksByProcessInstanceIdCommand();
        ArrayList resultTwo = new ArrayList();
        resp.addResult(resultTwo, 1, (Command)cmd);
        JaxbCommandsResponse newResp = this.testRoundTrip(resp);
        Assert.assertNotNull((Object)newResp);
        Assert.assertEquals((long)2L, (long)newResp.getResponses().size());
        Object newStringResp = this.deserialize(this.cmdRespXmlStr);
        Assert.assertNotNull((Object)newStringResp);
        Assert.assertEquals((long)2L, (long)((JaxbCommandsResponse)newStringResp).getResponses().size());
        List respList = ((JaxbCommandsResponse)newStringResp).getResponses();
    }
}

