/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.shrinkwrap.api.Archive;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.GetTasksByProcessInstanceIdCommand;
import org.jbpm.services.task.commands.GetTasksOwnedCommand;
import org.jbpm.services.task.commands.StartTaskCommand;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.services.client.api.RemoteJmsSessionFactory;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbLongListResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbTaskSummaryListResponse;
import org.kie.services.remote.IntegrationBase;
import org.kie.services.remote.setup.ArquillianJbossServerSetupTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={ArquillianJbossServerSetupTask.class})
public class RestAndJmsIntegrationTest
extends IntegrationBase {
    private static Logger logger = LoggerFactory.getLogger(RestAndJmsIntegrationTest.class);
    private static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory";
    private static final String DOMAIN_TASK_QUEUE_NAME = "jms/queue/KIE.TASK.DOMAIN.TEST";
    private static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    private static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE";
    @ArquillianResource
    URL deploymentUrl;
    private static final long QUALITY_OF_SERVICE_THRESHOLD_MS = 5000L;

    @Deployment(testable=false)
    public static Archive<?> createWar() {
        return RestAndJmsIntegrationTest.createWebArchive();
    }

    private static InitialContext getRemoteInitialContext() {
        Properties initialProps = new Properties();
        initialProps.setProperty("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
        initialProps.setProperty("java.naming.provider.url", "remote://localhost:4447");
        initialProps.setProperty("java.naming.security.principal", "guest");
        initialProps.setProperty("java.naming.security.credentials", "1234");
        for (Object keyObj : initialProps.keySet()) {
            String key = (String)keyObj;
            System.setProperty(key, (String)initialProps.get(key));
        }
        try {
            return new InitialContext(initialProps);
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to create " + InitialContext.class.getSimpleName(), e);
        }
    }

    @AfterClass
    public static void waitForTxOnServer() throws InterruptedException {
        Thread.sleep(1000L);
    }

    @Test
    @InSequence(value=0)
    public void testJmsStartProcess() throws Exception {
        StartProcessCommand cmd = new StartProcessCommand("org.jbpm.humantask");
        JaxbCommandsRequest req = new JaxbCommandsRequest("test", (Command)cmd);
        JaxbCommandsResponse response = this.sendJmsJaxbCommandsRequest(TASK_QUEUE_NAME, req);
        Assert.assertNotNull((String)"response was null.", (Object)response);
        Assert.assertTrue((String)"response did not contain any command responses", (response.getResponses() != null && response.getResponses().size() > 0 ? 1 : 0) != 0);
        JaxbCommandResponse cmdResponse = (JaxbCommandResponse)response.getResponses().get(0);
        Assert.assertTrue((String)("response is not the proper class type : " + cmdResponse.getClass().getSimpleName()), (boolean)(cmdResponse instanceof JaxbProcessInstanceResponse));
        ProcessInstance procInst = (ProcessInstance)cmdResponse;
        long procInstId = procInst.getId();
        cmd = new GetTasksByProcessInstanceIdCommand(procInstId);
        req = new JaxbCommandsRequest("test", (Command)cmd);
        response = this.sendJmsJaxbCommandsRequest(TASK_QUEUE_NAME, req);
        Assert.assertNotNull((String)"response was null.", (Object)response);
        Assert.assertTrue((String)"response did not contain any command responses", (response.getResponses() != null && response.getResponses().size() > 0 ? 1 : 0) != 0);
        cmdResponse = (JaxbCommandResponse)response.getResponses().get(0);
        Assert.assertTrue((String)("response is not the proper class type : " + cmdResponse.getClass().getSimpleName()), (boolean)(cmdResponse instanceof JaxbLongListResponse));
        long taskId = (Long)((JaxbLongListResponse)cmdResponse).getResult().get(0);
        cmd = new StartTaskCommand(taskId, "salaboy");
        req = new JaxbCommandsRequest("test", (Command)cmd);
        req.getCommands().add(new CompleteTaskCommand(taskId, "salaboy", null));
        response = this.sendJmsJaxbCommandsRequest(TASK_QUEUE_NAME, req);
        Assert.assertNotNull((String)"response was null.", (Object)response);
        Assert.assertTrue((String)"response list was not empty", (response.getResponses().size() == 0 ? 1 : 0) != 0);
        cmd = new GetTasksOwnedCommand("salaboy", "en-UK");
        req = new JaxbCommandsRequest("test", (Command)cmd);
        req.getCommands().add(new GetTasksOwnedCommand("bob", "fr-CA"));
        req.getCommands().add(new GetProcessInstanceCommand(Long.valueOf(procInstId)));
        response = this.sendJmsJaxbCommandsRequest(TASK_QUEUE_NAME, req);
        Assert.assertNotNull((String)"response was null.", (Object)response);
        Assert.assertTrue((String)"response did not contain any command responses", (response.getResponses() != null && response.getResponses().size() > 0 ? 1 : 0) != 0);
        cmdResponse = (JaxbCommandResponse)response.getResponses().get(0);
        Assert.assertTrue((String)("response is not the proper class type : " + cmdResponse.getClass().getSimpleName()), (boolean)(cmdResponse instanceof JaxbTaskSummaryListResponse));
        List taskSummaries = ((JaxbTaskSummaryListResponse)cmdResponse).getResult();
        Assert.assertTrue((String)"task summary list is empty", (taskSummaries.size() > 0 ? 1 : 0) != 0);
        for (TaskSummary taskSum : taskSummaries) {
            if (taskSum.getId() != taskId) continue;
            Assert.assertTrue((String)("Task " + taskId + " should have completed."), (boolean)taskSum.getStatus().equals((Object)Status.Completed));
        }
        cmdResponse = (JaxbCommandResponse)response.getResponses().get(1);
        Assert.assertTrue((String)("response is not the proper class type : " + cmdResponse.getClass().getSimpleName()), (boolean)(cmdResponse instanceof JaxbTaskSummaryListResponse));
        taskSummaries = ((JaxbTaskSummaryListResponse)cmdResponse).getResult();
        Assert.assertTrue((String)("task summary list should be empty, but has " + taskSummaries.size() + " elements"), (taskSummaries.size() == 0 ? 1 : 0) != 0);
        cmdResponse = (JaxbCommandResponse)response.getResponses().get(2);
        Assert.assertNotNull((Object)cmdResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaxbCommandsResponse sendJmsJaxbCommandsRequest(String sendQueueName, JaxbCommandsRequest req) throws Exception {
        InitialContext context = RestAndJmsIntegrationTest.getRemoteInitialContext();
        ConnectionFactory factory = (ConnectionFactory)context.lookup(CONNECTION_FACTORY_NAME);
        Queue jbpmQueue = (Queue)context.lookup(sendQueueName);
        Queue responseQueue = (Queue)context.lookup(RESPONSE_QUEUE_NAME);
        Connection connection = null;
        Session session = null;
        JaxbCommandsResponse cmdResponse = null;
        try {
            connection = factory.createConnection("guest", "1234");
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)jbpmQueue);
            MessageConsumer consumer = session.createConsumer((Destination)responseQueue);
            connection.start();
            BytesMessage msg = session.createBytesMessage();
            msg.setIntProperty("serialization", 1);
            String xmlStr = JaxbSerializationProvider.convertJaxbObjectToString((Object)req);
            msg.writeUTF(xmlStr);
            producer.send((Message)msg);
            Message response = consumer.receive(5000L);
            Assert.assertNotNull((String)"Response from MDB was null!", (Object)response);
            xmlStr = ((BytesMessage)response).readUTF();
            cmdResponse = (JaxbCommandsResponse)JaxbSerializationProvider.convertStringToJaxbObject((String)xmlStr);
            Assert.assertNotNull((String)"Jaxb Cmd Response was null!", (Object)cmdResponse);
        }
        finally {
            if (connection != null) {
                connection.close();
                session.close();
            }
        }
        return cmdResponse;
    }

    @Test
    @InSequence(value=1)
    @Ignore
    public void testRestUrlStartHumanTaskProcess() throws Exception {
        String urlString = new URL(this.deploymentUrl, "/arquillian-test/rest/runtime/test/process/org.jbpm.humantask/start").toExternalForm();
        System.out.println(">> " + urlString);
        ClientRequest restRequest = new ClientRequest(urlString);
        ClientResponse responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        urlString = this.deploymentUrl.toExternalForm() + "/rest/task/query?taskOwner=salaboy";
        restRequest = new ClientRequest(urlString);
        responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        JaxbTaskSummaryListResponse list = (JaxbTaskSummaryListResponse)responseObj.getEntity(JaxbTaskSummaryListResponse.class);
        long taskId = ((TaskSummary)list.getResult().get(0)).getId();
        urlString = new URL(this.deploymentUrl, "/arquillian-test/rest/task/" + taskId + "/start?userId=salaboy").toExternalForm();
        System.out.println(">> " + urlString);
        restRequest = new ClientRequest(urlString);
        responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
    }

    @Test
    @InSequence(value=2)
    public void testRestJaxbStartProcess() throws Exception {
        String urlString = new URL(this.deploymentUrl, "/arquillian-test/rest/runtime/test/execute").toExternalForm();
        System.out.println(">> " + urlString);
        ClientRequest restRequest = new ClientRequest(urlString);
        JaxbCommandsRequest commandMessage = new JaxbCommandsRequest("test", (Command)new StartProcessCommand("org.jbpm.humantask"));
        String body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)body);
        ClientResponse responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        JaxbCommandsResponse cmdsResp = (JaxbCommandsResponse)responseObj.getEntity(JaxbCommandsResponse.class);
        long procInstId = ((ProcessInstance)cmdsResp.getResponses().get(0)).getId();
        System.out.println(">> " + urlString);
        restRequest = new ClientRequest(urlString);
        commandMessage = new JaxbCommandsRequest("test", (Command)new GetTasksByProcessInstanceIdCommand(procInstId));
        body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)body);
        responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        JaxbCommandsResponse cmdResponse = (JaxbCommandsResponse)responseObj.getEntity(JaxbCommandsResponse.class);
        long taskId = (Long)((JaxbLongListResponse)cmdResponse.getResponses().get(0)).getResult().get(0);
        System.out.println(">> " + urlString);
        restRequest = new ClientRequest(urlString);
        commandMessage = new JaxbCommandsRequest((Command)new StartTaskCommand(taskId, "salaboy"));
        body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)commandMessage);
        responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        urlString = new URL(this.deploymentUrl, "/arquillian-test/rest/task/execute").toExternalForm();
        System.out.println(">> " + urlString);
        restRequest = new ClientRequest(urlString);
        commandMessage = new JaxbCommandsRequest((Command)new CompleteTaskCommand(taskId, "salaboy", null));
        body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)commandMessage);
        responseObj = restRequest.post();
        System.out.println(responseObj.getStatus());
    }

    @Test
    @InSequence(value=3)
    @Ignore
    public void testRestRemoteApiHumanTaskProcess() throws Exception {
        System.out.println("clientRestRequest()");
        RuntimeManager runtimeManager = new RemoteJmsSessionFactory("http://127.0.0.1:8080/arquillian-test", "test").newRuntimeManager();
        RuntimeEngine engine = runtimeManager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("org.jbpm.humantask");
        System.out.println("Started process instance: " + processInstance + " " + (processInstance == null ? "" : Long.valueOf(processInstance.getId())));
        TaskService taskService = engine.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        if (tasks.size() != 1) {
            throw new RuntimeException("Expecting one task " + tasks.size());
        }
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        System.out.println("Found task " + taskId);
        System.out.println(taskService.getTaskById(taskId));
        taskService.start(taskId, "salaboy");
        taskService.complete(taskId, "salaboy", null);
        boolean failure = false;
        System.out.println("Now expecting failure");
        try {
            taskService.complete(taskId, "salaboy", null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            failure = true;
        }
        if (!failure) {
            throw new RuntimeException("Cannot claim task twice");
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List taskIds = taskService.getTasksByStatusByProcessInstanceId(processInstance.getId(), statuses, "en-UK");
        if (taskIds.size() != 2) {
            throw new RuntimeException("Expecting two tasks");
        }
    }
}

