/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.setup;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArquillianJbossServerSetupTask
implements ServerSetupTask {
    protected static Properties arquillianLaunchProperties = ArquillianJbossServerSetupTask.getArquillianLaunchProperties();
    private static Logger logger = LoggerFactory.getLogger(ArquillianJbossServerSetupTask.class);
    public static final String HORNETQ_JMS_XML = "/hornetq-jms.xml";
    public static final String JBPM_DS_XML = "/jbpm-ds.xml";

    protected static Properties getArquillianLaunchProperties() {
        Properties properties = new Properties();
        try {
            InputStream arquillianLaunchFile = ArquillianJbossServerSetupTask.class.getResourceAsStream("/arquillian.launch");
            properties.load(arquillianLaunchFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        URL[] urls;
        logger.info("Deploying JMS Queues");
        URL hornetqJmsXmlUrl = this.getClass().getResource(HORNETQ_JMS_XML);
        URL jbpmDSXmlUrl = this.getClass().getResource(JBPM_DS_XML);
        for (URL url : urls = new URL[]{hornetqJmsXmlUrl, jbpmDSXmlUrl}) {
            DeploymentPlan plan;
            ServerDeploymentManager manager = ServerDeploymentManager.Factory.create((ModelControllerClient)managementClient.getControllerClient());
            Future future = manager.execute(plan = manager.newDeploymentPlan().add(url).andDeploy().build());
            ServerDeploymentPlanResult result = (ServerDeploymentPlanResult)future.get(10L, TimeUnit.SECONDS);
            ServerDeploymentActionResult actionResult = result.getDeploymentActionResult(plan.getId());
            if (actionResult == null || actionResult.getDeploymentException() == null) continue;
            throw new RuntimeException(actionResult.getDeploymentException());
        }
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        ServerDeploymentManager manager = ServerDeploymentManager.Factory.create((ModelControllerClient)managementClient.getControllerClient());
        DeploymentPlan undeployPlan = manager.newDeploymentPlan().undeploy(HORNETQ_JMS_XML).undeploy(JBPM_DS_XML).andRemoveUndeployed().build();
        manager.execute(undeployPlan).get();
    }
}

