/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.graph;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.services.remote.rest.graph.jaxb.ActiveNodeInfo;
import org.kie.services.remote.rest.graph.jaxb.DiagramInfo;
import org.kie.services.remote.rest.graph.jaxb.DiagramNodeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphViewerPluginImpl {
    private static final Logger logger = LoggerFactory.getLogger(GraphViewerPluginImpl.class);
    private KieBase kbase;
    private static final int BUFFER_SIZE = 512;

    public List<ActiveNodeInfo> getActiveNodeInfo(String instanceId) {
        ProcessInstanceLog processInstance = JPAProcessInstanceDbLog.findProcessInstance((long)new Long(instanceId));
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance " + instanceId);
        }
        HashMap<String, NodeInstanceLog> nodeInstances = new HashMap<String, NodeInstanceLog>();
        for (NodeInstanceLog nodeInstance : JPAProcessInstanceDbLog.findNodeInstances((long)new Long(instanceId))) {
            if (nodeInstance.getType() == 0) {
                nodeInstances.put(nodeInstance.getNodeInstanceId(), nodeInstance);
                continue;
            }
            nodeInstances.remove(nodeInstance.getNodeInstanceId());
        }
        if (!nodeInstances.isEmpty()) {
            ArrayList<ActiveNodeInfo> result = new ArrayList<ActiveNodeInfo>();
            for (NodeInstanceLog nodeInstance : nodeInstances.values()) {
                boolean found = false;
                DiagramInfo diagramInfo = this.getDiagramInfo(processInstance.getProcessId());
                if (diagramInfo != null) {
                    for (DiagramNodeInfo nodeInfo : diagramInfo.getNodeList()) {
                        if (!nodeInfo.getName().equals("id=" + nodeInstance.getNodeId())) continue;
                        result.add(new ActiveNodeInfo(diagramInfo.getWidth(), diagramInfo.getHeight(), nodeInfo));
                        found = true;
                        break;
                    }
                } else {
                    throw new IllegalArgumentException("Could not find info for diagram for process " + processInstance.getProcessId());
                }
                if (found) continue;
                throw new IllegalArgumentException("Could not find info for node " + nodeInstance.getNodeId() + " of process " + processInstance.getProcessId());
            }
            return result;
        }
        return null;
    }

    public DiagramInfo getDiagramInfo(String processId) {
        Process process = this.kbase.getProcess(processId);
        if (process == null) {
            return null;
        }
        DiagramInfo result = new DiagramInfo();
        result.setWidth(932);
        result.setHeight(541);
        ArrayList<DiagramNodeInfo> nodeList = new ArrayList<DiagramNodeInfo>();
        if (process instanceof WorkflowProcess) {
            this.addNodesInfo(nodeList, ((WorkflowProcess)process).getNodes(), "id=");
        }
        result.setNodeList(nodeList);
        return result;
    }

    private void addNodesInfo(List<DiagramNodeInfo> nodeInfos, Node[] nodes, String prefix) {
        for (Node node : nodes) {
            nodeInfos.add(new DiagramNodeInfo(prefix + node.getId(), (Integer)node.getMetaData().get("x"), (Integer)node.getMetaData().get("y"), (Integer)node.getMetaData().get("width"), (Integer)node.getMetaData().get("height")));
            if (!(node instanceof NodeContainer)) continue;
            this.addNodesInfo(nodeInfos, ((NodeContainer)node).getNodes(), prefix + node.getId() + ":");
        }
    }

    public byte[] getProcessImage(String processId) {
        return null;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
            bytesRead = in.read(buffer);
        }
        return total;
    }

    public URL getDiagramURL(String id) {
        URL result = GraphViewerPluginImpl.class.getResource("/" + id + ".png");
        if (result != null) {
            return result;
        }
        return null;
    }

    public List<ActiveNodeInfo> getNodeInfoForActivities(String processDefinitionId, List<String> activities) {
        return new ArrayList<ActiveNodeInfo>();
    }
}

