/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.jaxb;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jboss.resteasy.spi.BadRequestException;
import org.kie.services.remote.rest.jaxb.JaxbRequestStatus;

@XmlRootElement(name="response")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbGenericResponse {
    @XmlElement
    private JaxbRequestStatus status;
    @XmlElement
    @XmlSchemaType(name="anyURI")
    private String url;
    @XmlElement
    @XmlSchemaType(name="string")
    private String error;
    @XmlElement
    @XmlSchemaType(name="string")
    private String stackTrace;

    public JaxbGenericResponse() {
    }

    public JaxbGenericResponse(HttpServletRequest request) {
        this.url = this.getUrl(request);
        this.status = JaxbRequestStatus.SUCCESS;
    }

    public JaxbGenericResponse(HttpServletRequest request, Exception e) {
        this.url = this.getUrl(request);
        this.error = e.getMessage();
        if (!(e instanceof BadRequestException)) {
            this.status = JaxbRequestStatus.FAILURE;
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            e.printStackTrace(writer);
            this.stackTrace = stringWriter.toString();
        } else {
            this.status = JaxbRequestStatus.BAD_REQUEST;
        }
    }

    private String getUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        if (request.getQueryString() != null) {
            url = url + "?" + request.getQueryString();
        }
        return url;
    }

    public static String convertStackTraceToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    public String prettyPrint() throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this, (Writer)writer);
        return writer.toString();
    }

    public JaxbRequestStatus getStatus() {
        return this.status;
    }

    public String getUrl() {
        return this.url;
    }

    public String getError() {
        return this.error;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }
}

