/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.cdi;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.services.remote.cdi.RuntimeManagerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProcessRequestBean {
    private static Logger logger = LoggerFactory.getLogger(ProcessRequestBean.class);
    private static CorrelationKeyFactory keyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    @Inject
    private RuntimeManagerManager runtimeMgrMgr;
    @Inject
    private TaskService taskService;

    public Object doKieSessionOperation(Command cmd, String deploymentId) {
        return this.doKieSessionOperation(cmd, deploymentId, null);
    }

    public Object doKieSessionOperation(Command cmd, String deploymentId, Long processInstanceId) {
        KieSession kieSession = this.getRuntimeEngine(deploymentId, processInstanceId).getKieSession();
        Object result = kieSession.execute(cmd);
        return result;
    }

    public Object doTaskOperation(Command cmd) {
        Object result = ((InternalTaskService)this.taskService).execute(cmd);
        return result;
    }

    protected RuntimeEngine getRuntimeEngine(String domainName, Long processInstanceId) {
        RuntimeManager runtimeManager = this.runtimeMgrMgr.getRuntimeManager(domainName);
        Object runtimeContext = processInstanceId != null ? new ProcessInstanceIdContext(processInstanceId) : EmptyContext.get();
        return runtimeManager.getRuntimeEngine(runtimeContext);
    }
}

