/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.jboss.resteasy.spi.BadRequestException;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbProcessInstanceResponse;
import org.kie.services.remote.cdi.ProcessRequestBean;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.jaxb.JaxbGenericResponse;
import org.kie.services.remote.util.CommandsRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/runtime/{id: [a-zA-Z0-9-:\\.]+}")
@RequestScoped
public class RuntimeResource
extends ResourceBase {
    private Logger logger = LoggerFactory.getLogger(RuntimeResource.class);
    @Inject
    private ProcessRequestBean processRequestBean;
    @PathParam(value="id")
    private String deploymentId;
    @Context
    private HttpServletRequest request;

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return CommandsRequestUtil.processJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/process/{processDefId: [a-zA-Z0-9-:\\.]+}/start")
    public JaxbGenericResponse startNewProcess(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(formParams, "process/" + processId + "/start");
        StartProcessCommand cmd = new StartProcessCommand(processId, params);
        this.processRequestBean.doKieSessionOperation((Command)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    public JaxbProcessInstanceResponse getProcessInstanceDetails(@PathParam(value="procInstId") Long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        Object result = this.processRequestBean.doKieSessionOperation((Command)cmd, this.deploymentId);
        return new JaxbProcessInstanceResponse((ProcessInstance)result);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}")
    public JaxbGenericResponse doProcessInstanceOperation(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        StartProcessInstanceCommand cmd = null;
        if ("start".equals(operation.toLowerCase().trim())) {
            cmd = new StartProcessInstanceCommand(procInstId);
        } else if ("signal".equals(operation.toLowerCase().trim())) {
            String eventType = RuntimeResource.getStringParam("eventType", true, formParams, operation);
            Object event = RuntimeResource.getObjectParam("event", false, formParams, operation);
            cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        } else if ("abort".equals(operation.toLowerCase().trim())) {
            cmd = new AbortProcessInstanceCommand();
            ((AbortProcessInstanceCommand)cmd).setProcessInstanceId(procInstId);
        } else {
            throw new BadRequestException("Unsupported operation: /process/instance/" + procInstId + "/" + operation);
        }
        this.processRequestBean.doKieSessionOperation((Command)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/signal/{signal: [a-zA-Z0-9-]+}")
    public JaxbGenericResponse signalEvent(@PathParam(value="signal") String signal) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Object event = RuntimeResource.getObjectParam("event", false, formParams, "signal/" + signal);
        SignalEventCommand cmd = new SignalEventCommand(signal, event);
        this.processRequestBean.doKieSessionOperation((Command)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public JaxbGenericResponse doWorkItemOperation(@PathParam(value="workItemId") Long workItemId, @PathParam(value="oper") String operation) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        CompleteWorkItemCommand cmd = null;
        if ("complete".equalsIgnoreCase(operation.trim())) {
            Map<String, Object> results = RuntimeResource.extractMapFromParams(formParams, operation);
            cmd = new CompleteWorkItemCommand(workItemId.longValue(), results);
        } else if ("abort".equals(operation.toLowerCase())) {
            cmd = new AbortWorkItemCommand(workItemId.longValue());
        } else {
            throw new BadRequestException("Unsupported operation: /process/instance/" + workItemId + "/" + operation);
        }
        this.processRequestBean.doKieSessionOperation((Command)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }
}

