/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.jms;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.MessageDrivenContext;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBException;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.JaxbSerializationProvider;
import org.kie.services.remote.KieRemoteServicesInternalError;
import org.kie.services.remote.cdi.ProcessRequestBean;
import org.kie.services.remote.util.CommandsRequestUtil;

public class RequestMessageBean
implements MessageListener {
    @Inject
    private Logger logger;
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Inject
    private ProcessRequestBean processRequestBean;
    @Resource
    private MessageDrivenContext msgContext;
    private String RESPONSE_QUEUE_NAME = null;
    private static String RESPONSE_QUEUE_NAME_PROPERTY = "kie.services.jms.queues.response";

    @PostConstruct
    public void init() {
        this.RESPONSE_QUEUE_NAME = System.getProperty(RESPONSE_QUEUE_NAME_PROPERTY, "queue/KIE.RESPONSE.ALL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Session session;
        Connection connection;
        JaxbCommandsResponse jaxbResponse;
        int[] serializationTypeHolder;
        String msgCorrId;
        boolean failure;
        block35: {
            JaxbCommandsRequest cmdsRequest;
            failure = false;
            msgCorrId = null;
            try {
                msgCorrId = message.getJMSCorrelationID();
            }
            catch (JMSException jmse) {
                this.logger.log(Level.WARNING, "Unable to retrieve JMS correlation id from message! This id is needed to be able to match a request to a response message.", jmse);
            }
            if (msgCorrId == null) {
                this.logger.log(Level.WARNING, "JMS correlation id is empty! This id is needed to be able to match a request to a response message.");
            }
            if ((cmdsRequest = this.deserializeRequest(message, msgCorrId, serializationTypeHolder = new int[1])) == null) {
                this.logger.log(Level.SEVERE, "Stopping processing of request message due to errors: see above.");
                return;
            }
            jaxbResponse = CommandsRequestUtil.processJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
            connection = null;
            session = null;
            try {
                connection = this.connectionFactory.createConnection();
                connection.start();
                session = connection.createSession(false, 1);
            }
            catch (JMSException jmse) {
                this.logger.log(Level.SEVERE, "Unable to open new session to send response message to message " + msgCorrId, jmse);
                failure = true;
            }
            finally {
                if (!failure) break block35;
                if (connection != null) {
                    try {
                        connection.close();
                        connection = null;
                        session.close();
                        session = null;
                    }
                    catch (JMSException jmse) {
                        this.logger.log(Level.INFO, "Unable to close connection or session after failing to create connection or session.", jmse);
                    }
                }
                return;
            }
        }
        Message msg = this.serializeResponse(session, msgCorrId, serializationTypeHolder[0], jaxbResponse);
        try {
            msg.setJMSCorrelationID(msgCorrId);
        }
        catch (JMSException jmse) {
            this.logger.log(Level.WARNING, "Unable to set correlation id of response to msg id " + msgCorrId, jmse);
        }
        if (!failure) {
            try {
                InitialContext context = new InitialContext();
                Queue responseQueue = (Queue)context.lookup(this.RESPONSE_QUEUE_NAME);
                MessageProducer producer = session.createProducer((Destination)responseQueue);
                producer.send(msg);
            }
            catch (NamingException ne) {
                this.logger.log(Level.SEVERE, "Unable to lookup response queue (" + this.RESPONSE_QUEUE_NAME + ") to send msg " + msgCorrId + " (Is " + RESPONSE_QUEUE_NAME_PROPERTY + " incorrect?).", ne);
            }
            catch (JMSException jmse) {
                this.logger.log(Level.SEVERE, "Unable to send msg " + msgCorrId + " to " + this.RESPONSE_QUEUE_NAME, jmse);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        connection = null;
                        session.close();
                        session = null;
                    }
                    catch (JMSException jmse) {
                        this.logger.log(Level.INFO, "Unable to close connection or session.", jmse);
                    }
                }
            }
        }
    }

    private JaxbCommandsRequest deserializeRequest(Message message, String msgId, int[] serializationTypeHolder) {
        JaxbCommandsRequest cmdMsg = null;
        try {
            serializationTypeHolder[0] = message.getIntProperty("serialization");
            if (serializationTypeHolder[0] != 1) {
                throw new KieRemoteServicesInternalError("Unknown serialization type when deserializing message " + msgId + ":" + serializationTypeHolder[0]);
            }
            String msgStrContent = ((BytesMessage)message).readUTF();
            cmdMsg = (JaxbCommandsRequest)JaxbSerializationProvider.convertStringToJaxbObject((String)msgStrContent);
        }
        catch (JMSException jmse) {
            this.logger.log(Level.SEVERE, "Unable to read information from message " + msgId + ".", jmse);
        }
        catch (JAXBException jaxbe) {
            throw new KieRemoteServicesInternalError("Unable to convert String to " + JaxbCommandsRequest.class.getSimpleName() + " [msg id: " + msgId + "].", jaxbe);
        }
        return cmdMsg;
    }

    private Message serializeResponse(Session session, String msgId, int serializationType, JaxbCommandsResponse jaxbResponse) {
        BytesMessage byteMsg = null;
        try {
            byteMsg = session.createBytesMessage();
            byteMsg.setIntProperty("serialization", serializationType);
            if (serializationType != 1) {
                throw new KieRemoteServicesInternalError("Unknown serialization type when deserializing message " + msgId + ":" + serializationType);
            }
            String xmlStr = JaxbSerializationProvider.convertJaxbObjectToString((Object)jaxbResponse);
            byteMsg.writeUTF(xmlStr);
        }
        catch (JMSException jmse) {
            this.logger.log(Level.SEVERE, "Unable to create response message or write to it [msg id: " + msgId + "].", jmse);
        }
        catch (JAXBException jaxbe) {
            throw new KieRemoteServicesInternalError("Unable to serialize " + jaxbResponse.getClass().getSimpleName() + " to a String.", jaxbe);
        }
        return byteMsg;
    }
}

