/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.jboss.resteasy.spi.BadRequestException;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.command.ClearHistoryLogsCommand;
import org.jbpm.process.audit.command.FindNodeInstancesCommand;
import org.jbpm.process.audit.command.FindProcessInstanceCommand;
import org.jbpm.process.audit.command.FindProcessInstancesCommand;
import org.jbpm.process.audit.command.FindSubProcessInstancesCommand;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.remote.cdi.ProcessRequestBean;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.util.CommandsRequestUtil;

@Path(value="/runtime/{id: [a-zA-Z0-9-:\\.]+}")
@RequestScoped
public class RuntimeResource
extends ResourceBase {
    @Inject
    private ProcessRequestBean processRequestBean;
    @Inject
    private Logger logger;
    @PathParam(value="id")
    private String deploymentId;
    @Context
    private HttpServletRequest request;

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return CommandsRequestUtil.processJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/process/{processDefId: [a-zA-Z0-9-:\\.]+}/start")
    public JaxbProcessInstanceResponse startNewProcess(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(formParams, "process/" + processId + "/start");
        StartProcessCommand cmd = new StartProcessCommand(processId, params);
        ProcessInstance procInst = (ProcessInstance)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        JaxbProcessInstanceResponse resp = new JaxbProcessInstanceResponse(procInst, this.request);
        return resp;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    public JaxbProcessInstanceResponse getProcessInstanceDetails(@PathParam(value="procInstId") Long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        if (result != null) {
            return new JaxbProcessInstanceResponse((ProcessInstance)result);
        }
        throw new BadRequestException("Unable to retrieve process instance " + procInstId + " since it has been completed. Please see the history operations.");
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}/abort")
    public JaxbGenericResponse abortProcessInstanceOperation(@PathParam(value="procInstId") Long procInstId) {
        AbortProcessInstanceCommand cmd = new AbortProcessInstanceCommand();
        cmd.setProcessInstanceId(procInstId);
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}/signal")
    public JaxbGenericResponse signalProcessInstanceOperation(@PathParam(value="procInstId") Long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("eventType", true, params, "signal");
        Object event = RuntimeResource.getObjectParam("event", false, params, "signal");
        SignalEventCommand cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}/start")
    public JaxbProcessInstanceResponse startProcessInstanceOperation(@PathParam(value="procInstId") Long procInstId) {
        StartProcessInstanceCommand cmd = new StartProcessInstanceCommand(procInstId);
        ProcessInstance procInst = (ProcessInstance)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        return new JaxbProcessInstanceResponse(procInst, this.request);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/signal/{signal: [a-zA-Z0-9-]+}")
    public JaxbGenericResponse signalEvent(@PathParam(value="signal") String signal) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Object event = RuntimeResource.getObjectParam("event", false, formParams, "signal/" + signal);
        SignalEventCommand cmd = new SignalEventCommand(signal, event);
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public JaxbGenericResponse doWorkItemOperation(@PathParam(value="workItemId") Long workItemId, @PathParam(value="oper") String operation) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        CompleteWorkItemCommand cmd = null;
        if ("complete".equalsIgnoreCase(operation.trim())) {
            Map<String, Object> results = RuntimeResource.extractMapFromParams(params, operation);
            cmd = new CompleteWorkItemCommand(workItemId.longValue(), results);
        } else if ("abort".equalsIgnoreCase(operation.toLowerCase())) {
            cmd = new AbortWorkItemCommand(workItemId.longValue());
        } else {
            throw new BadRequestException("Unsupported operation: /process/instance/" + workItemId + "/" + operation);
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/history/clear")
    public JaxbGenericResponse clearProcessInstanceLogs() {
        ClearHistoryLogsCommand cmd = new ClearHistoryLogsCommand();
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        return new JaxbGenericResponse(this.request);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/instance")
    public JaxbHistoryLogList getProcessInstanceLogs() {
        FindProcessInstancesCommand cmd = new FindProcessInstancesCommand();
        List procInstLogList = (List)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        return new JaxbHistoryLogList(procInstLogList);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/instance/{procInstId: [0-9]+}")
    public JaxbHistoryLogList getSpecificProcessInstanceLogs(@PathParam(value="procInstId") long procInstId) {
        FindProcessInstanceCommand cmd = new FindProcessInstanceCommand(procInstId);
        ProcessInstanceLog procInstLog = (ProcessInstanceLog)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        ArrayList<ProcessInstanceLog> logList = new ArrayList<ProcessInstanceLog>();
        logList.add(procInstLog);
        return new JaxbHistoryLogList(logList);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}")
    public JaxbHistoryLogList getVariableOrNodeHistoryList(@PathParam(value="procInstId") Long processInstanceId, @PathParam(value="oper") String operation) {
        JaxbHistoryLogList resultList;
        if ("child".equalsIgnoreCase(operation)) {
            FindSubProcessInstancesCommand cmd = new FindSubProcessInstancesCommand(processInstanceId.longValue());
            List procInstLogList = (List)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
            resultList = new JaxbHistoryLogList(procInstLogList);
        } else if ("node".equalsIgnoreCase(operation)) {
            FindNodeInstancesCommand cmd = new FindNodeInstancesCommand(processInstanceId.longValue());
            List nodeInstLogList = (List)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
            resultList = new JaxbHistoryLogList(nodeInstLogList);
        } else if ("variable".equalsIgnoreCase(operation)) {
            FindVariableInstancesCommand cmd = new FindVariableInstancesCommand(processInstanceId.longValue());
            List varInstLogList = (List)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
            resultList = new JaxbHistoryLogList(varInstLogList);
        } else {
            throw new BadRequestException("Unsupported operation: /history/instance/" + processInstanceId + "/" + operation);
        }
        return resultList;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}/{id: [a-zA-Z0-9-:\\.]+}")
    public JaxbHistoryLogList getSpecificVariableOrNodeHistoryList(@PathParam(value="procInstId") Long processInstanceId, @PathParam(value="oper") String operation, @PathParam(value="id") String id) {
        JaxbHistoryLogList resultList;
        if ("node".equalsIgnoreCase(operation)) {
            FindNodeInstancesCommand cmd = new FindNodeInstancesCommand(processInstanceId.longValue(), id);
            List nodeInstLogList = (List)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
            resultList = new JaxbHistoryLogList(nodeInstLogList);
        } else if ("variable".equalsIgnoreCase(operation)) {
            FindVariableInstancesCommand cmd = new FindVariableInstancesCommand(processInstanceId.longValue(), id);
            List varInstLogList = (List)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
            resultList = new JaxbHistoryLogList(varInstLogList);
        } else {
            throw new BadRequestException("Unsupported operation: /history/instance/" + processInstanceId + "/" + operation + "/" + id);
        }
        return resultList;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/process/{procId: [a-zA-Z0-9-:\\.]+}")
    public JaxbHistoryLogList getProcessInstanceLogs(@PathParam(value="procInstId") String processId) {
        FindProcessInstancesCommand cmd = new FindProcessInstancesCommand(processId);
        List nodeInstLogList = (List)this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId);
        return new JaxbHistoryLogList(nodeInstLogList);
    }
}

