/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.util;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.api.command.Command;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.remote.cdi.ProcessRequestBean;

public class CommandsRequestUtil {
    public static JaxbCommandsResponse processJaxbCommandsRequest(JaxbCommandsRequest request, ProcessRequestBean requestBean) {
        Logger logger = requestBean.getLogger();
        JaxbCommandsResponse jaxbResponse = new JaxbCommandsResponse(request);
        String deploymentId = request.getDeploymentId();
        Long processInstanceId = request.getProcessInstanceId();
        List commands = request.getCommands();
        for (int i = 0; i < commands.size(); ++i) {
            Command cmd = (Command)commands.get(i);
            boolean exceptionThrown = false;
            Object cmdResult = null;
            try {
                cmdResult = cmd instanceof TaskCommand ? requestBean.doTaskOperation(cmd) : requestBean.doKieSessionOperation(cmd, deploymentId, processInstanceId);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to execute " + cmd.getClass().getSimpleName() + "/" + i + " because of " + e.getClass().getSimpleName(), e);
                jaxbResponse.addException(e, i, cmd);
            }
            if (exceptionThrown || cmdResult == null) continue;
            try {
                jaxbResponse.addResult(cmdResult, i, cmd);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to add result from " + cmd.getClass().getSimpleName() + "/" + i + " because of " + e.getClass().getSimpleName(), e);
            }
        }
        return jaxbResponse;
    }
}

