/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.kie.commons.java.nio.file.spi.FileSystemProvider;
import org.kie.commons.java.nio.fs.file.SimpleFileSystemProvider;
import org.kie.services.remote.exception.KieRemoteServicesInternalError;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.server.auth.source.PropertyUserSource;

public class IntegrationTestBase {
    protected static final String projectVersion;

    protected static InitialContext getRemoteInitialContext() {
        Properties initialProps = new Properties();
        initialProps.setProperty("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
        initialProps.setProperty("java.naming.provider.url", "remote://localhost:4447");
        initialProps.setProperty("java.naming.security.principal", "guest");
        initialProps.setProperty("java.naming.security.credentials", "1234");
        for (Object keyObj : initialProps.keySet()) {
            String key = (String)keyObj;
            System.setProperty(key, (String)initialProps.get(key));
        }
        try {
            return new InitialContext(initialProps);
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to create " + InitialContext.class.getSimpleName(), e);
        }
    }

    static WebArchive createWebArchive() {
        ArrayList<MavenResolvedArtifact> artifacts = new ArrayList<MavenResolvedArtifact>();
        MavenResolvedArtifact[] runtimeArtifacts = (MavenResolvedArtifact[])((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).importRuntimeDependencies().asResolvedArtifact();
        artifacts.addAll(Arrays.asList(runtimeArtifacts));
        String[] warDeps = new String[]{"org.jboss.solder:solder-impl", "org.jbpm:jbpm-audit", "org.jbpm:jbpm-persistence-jpa", "org.jbpm:jbpm-runtime-manager", "org.jbpm:jbpm-kie-services", "org.kie.commons:kie-nio2-fs", "org.jbpm:jbpm-shared-services:test-jar:" + projectVersion, "org.uberfire:uberfire-security-server", "org.codehaus.btm:btm"};
        MavenResolvedArtifact[] warArtifacts = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve(warDeps)).withTransitivity()).asResolvedArtifact();
        artifacts.addAll(Arrays.asList(warArtifacts));
        ArrayList<File> libList = new ArrayList<File>();
        HashSet<String> depSet = new HashSet<String>();
        for (MavenResolvedArtifact artifact : artifacts) {
            String artifactId;
            MavenCoordinate depCoord = artifact.getCoordinate();
            if (depCoord.getGroupId().contains("dom4j") || !depSet.add(artifactId = depCoord.getArtifactId())) continue;
            libList.add(artifact.asFile());
        }
        File[] libs = libList.toArray(new File[libList.size()]);
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"arquillian-test.war")).addPackages(true, new String[]{"org/kie/services/remote/cdi", "org/kie/services/remote/jms", "org/kie/services/remote/rest", "org/kie/services/remote/util", "org/kie/services/remote/exception"})).addPackages(true, new String[]{"org/kie/services/remote/war"})).addClass(KieRemoteServicesInternalError.class)).addAsResource("META-INF/persistence.xml")).addAsServiceProvider(FileSystemProvider.class, new Class[]{SimpleFileSystemProvider.class})).addAsServiceProvider(AuthenticationSource.class, new Class[]{PropertyUserSource.class})).addAsResource("users.properties")).addAsWebInfResource("WEB-INF/test-beans.xml", "beans.xml")).addAsWebInfResource("META-INF/ejb-jar.xml", "ejb-jar.xml")).setWebXML("WEB-INF/web.xml")).addAsLibraries(libs);
        ((ZipExporter)war.as(ZipExporter.class)).exportTo(new File("target/" + war.getName()), true);
        return war;
    }

    static {
        Properties testProps = new Properties();
        try {
            testProps.load(IntegrationTestBase.class.getResourceAsStream("/test.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize DroolsVersion property: " + e.getMessage(), e);
        }
        projectVersion = testProps.getProperty("project.version");
    }
}

